/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.stash.internal.backup.liquibase.LiquibaseChangeSetMetaData;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ChangeLogOutline
implements Iterable<LiquibaseChangeSetMetaData> {
    private final List<LiquibaseChangeSetMetaData> changeSetMetaDatas;
    private final int nonEmptyChangeSetCount;

    ChangeLogOutline(Iterable<Long> changeCounts) {
        int size = Iterables.size(changeCounts);
        this.changeSetMetaDatas = new ArrayList<LiquibaseChangeSetMetaData>(size);
        long totalChangeCount = 0L;
        int nonEmptyChangeSetCount = 0;
        for (Long changeCount : changeCounts) {
            totalChangeCount += changeCount.longValue();
            if (changeCount <= 0L) continue;
            ++nonEmptyChangeSetCount;
        }
        double cumulativeProgress = 0.0;
        for (Long changeCount : changeCounts) {
            int progress = Math.min(100, (int)Math.ceil((cumulativeProgress += (double)changeCount.longValue() / (double)totalChangeCount) * 100.0));
            this.changeSetMetaDatas.add(new LiquibaseChangeSetMetaData(changeCount, progress));
        }
        this.nonEmptyChangeSetCount = nonEmptyChangeSetCount;
    }

    @Override
    public Iterator<LiquibaseChangeSetMetaData> iterator() {
        return this.changeSetMetaDatas.iterator();
    }

    public int nonEmptyChangeSetCount() {
        return this.nonEmptyChangeSetCount;
    }
}

