/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.bitbucket.util.CancelState;
import com.atlassian.stash.internal.backup.liquibase.ColumnParsingContext;
import com.atlassian.stash.internal.backup.liquibase.ColumnSerialisationType;
import com.atlassian.stash.internal.backup.liquibase.processors.ChangeSetProcessor;
import com.atlassian.stash.internal.backup.liquibase.xml.XmlEncoder;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import liquibase.change.core.DeleteDataChange;
import liquibase.change.core.InsertDataChange;
import liquibase.changelog.ChangeSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ChangeSetReader
extends DefaultHandler {
    private final CancelState cancelState;
    private final ChangeSetProcessor processor;
    private final XmlEncoder xmlEncoder;
    private ChangeSet changeSet;
    private ColumnParsingContext columnContext;
    private DeleteDataChange deleteDataChange;
    private InsertDataChange insertDataChange;

    public ChangeSetReader(@Nonnull CancelState cancelState, @Nonnull ChangeSetProcessor processor, @Nonnull XmlEncoder xmlEncoder) {
        this.cancelState = Objects.requireNonNull(cancelState, "cancelState");
        this.processor = Objects.requireNonNull(processor, "processor");
        this.xmlEncoder = Objects.requireNonNull(xmlEncoder, "xmlEncoder");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.cancelState.isCanceled() && this.columnContext != null) {
            this.columnContext.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.cancelState.isCanceled()) {
            return;
        }
        if (this.changeSet != null && "changeSet".equals(qName)) {
            this.processor.onChangesetComplete(this.changeSet);
            this.changeSet = null;
        } else if (this.columnContext != null && "column".equals(qName)) {
            this.insertDataChange.addColumn(this.columnContext.asColumnConfig(this.xmlEncoder));
            this.columnContext = null;
        } else if (this.insertDataChange != null && "insert".equals(qName)) {
            if (this.insertDataChange.getColumns().size() > 0) {
                this.processor.onChangesetContent(this.insertDataChange);
                this.insertDataChange = null;
            }
        } else if (this.deleteDataChange != null && "delete".equals(qName)) {
            this.processor.onChangesetContent(this.deleteDataChange);
            this.deleteDataChange = null;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.cancelState.isCanceled()) {
            return;
        }
        if (this.changeSet == null && "changeSet".equals(qName)) {
            this.changeSet = this.newChangeSet(attributes);
            this.processor.onChangesetBegin(this.changeSet);
        } else if (this.changeSet != null && this.insertDataChange == null && "insert".equals(qName)) {
            this.insertDataChange = new InsertDataChange();
            this.insertDataChange.setTableName(attributes.getValue("tableName"));
        } else if (this.changeSet != null && this.deleteDataChange == null && "delete".equals(qName)) {
            this.deleteDataChange = new DeleteDataChange();
            this.deleteDataChange.setTableName(attributes.getValue("tableName"));
        } else if (this.insertDataChange != null && "column".equals(qName)) {
            String columnName = attributes.getValue("name");
            ColumnSerialisationType columnSerialisationType = ColumnSerialisationType.fromString(attributes.getValue("colType")).get();
            this.columnContext = new ColumnParsingContext(columnName, columnSerialisationType);
        }
    }

    private ChangeSet newChangeSet(Attributes attributes) {
        return new ChangeSet(attributes.getValue("id"), attributes.getValue("author"), false, false, "restore", attributes.getValue("context"), attributes.getValue("dbms"), false, null);
    }
}

