/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.stash.internal.backup.liquibase.ChangeLogOutline;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseChangeSet;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseChangeSetMetaData;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDao;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseRestoreMonitor;
import com.atlassian.stash.internal.backup.liquibase.processors.ChangeSetProcessor;
import com.google.common.collect.Iterators;
import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.Objects;
import liquibase.change.core.DeleteDataChange;
import liquibase.change.core.InsertDataChange;
import liquibase.changelog.ChangeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatabaseUpdater
implements ChangeSetProcessor {
    private static final Logger log = LoggerFactory.getLogger(DatabaseUpdater.class);
    private final Iterator<LiquibaseChangeSetMetaData> outline;
    private final LiquibaseDao dao;
    private final LiquibaseRestoreMonitor monitor;
    private final int totalNonEmptyChangesetCount;
    private int changeSetCount;
    private boolean skipChangeset;

    DatabaseUpdater(@Nonnull LiquibaseDao dao, @Nonnull LiquibaseRestoreMonitor monitor, @Nonnull ChangeLogOutline outline) {
        this.dao = Objects.requireNonNull(dao, "liquibaseDao");
        this.monitor = Objects.requireNonNull(monitor, "liquibaseRestoreMonitor");
        this.outline = Objects.requireNonNull(outline, "outline").iterator();
        this.totalNonEmptyChangesetCount = outline.nonEmptyChangeSetCount();
    }

    @Override
    public void onChangesetBegin(ChangeSet changeSet) {
        LiquibaseChangeSetMetaData changeSetSummary = (LiquibaseChangeSetMetaData)Iterators.getNext(this.outline, null);
        if (changeSetSummary != null && changeSetSummary.getChangeCount() > 0L) {
            this.skipChangeset = false;
            log.debug("Executing changeset {} of {}, containing {} changes with id {}", new Object[]{this.changeSetCount, this.totalNonEmptyChangesetCount, changeSetSummary.getChangeCount(), changeSet.getId()});
            ++this.changeSetCount;
            this.monitor.onBeginChangeset((LiquibaseChangeSet)changeSetSummary, this.changeSetCount, this.totalNonEmptyChangesetCount);
            this.dao.beginChangeSet();
        } else {
            this.skipChangeset = true;
        }
    }

    @Override
    public void onChangesetContent(DeleteDataChange change) {
        this.dao.deleteAllRows(change.getTableName());
        this.monitor.onAppliedChange();
    }

    @Override
    public void onChangesetContent(InsertDataChange change) {
        this.dao.insert(change);
        this.monitor.onAppliedChange();
    }

    @Override
    public void onChangesetComplete(ChangeSet changeSet) {
        if (!this.skipChangeset) {
            this.dao.endChangeSet();
            this.monitor.onFinishedChangeset();
        }
    }
}

