/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.bitbucket.util.CancelState;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.backup.liquibase.DecodeBase64Function;
import com.atlassian.stash.internal.backup.liquibase.DefaultLiquibaseSession;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseChangeExecutionException;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDao;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDataAccessException;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseSessionThreadLocal;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.DeleteDataChange;
import liquibase.change.core.InsertDataChange;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.lockservice.LockService;
import liquibase.lockservice.StandardLockService;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.statement.DatabaseFunction;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.JdbcUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Component;

@Component(value="liquibaseDao")
public class DefaultLiquibaseDao
implements ApplicationContextAware,
LiquibaseDao {
    public static final DatabaseChangeLog EMPTY_CHANGE_LOG = new DatabaseChangeLog();
    public static final List<SqlVisitor> NO_VISITORS = ImmutableList.of();
    private static final Logger log = LoggerFactory.getLogger(DefaultLiquibaseDao.class);
    private static final int FETCH_SIZE = 1000;
    private static final Consumer<LockService> RELEASE_LOCK = l -> {
        try {
            log.debug("Unlocking Liquibase");
            l.releaseLock();
            log.debug("Liquibase unlocked");
        }
        catch (LockException e) {
            log.error("Failed to release Liquibase lock", (Throwable)e);
        }
    };
    private final LiquibaseSessionThreadLocal databaseSession;
    private final long commitBlockSize;
    private LockService lockService;
    private ApplicationContext applicationContext;

    @Autowired
    public DefaultLiquibaseDao(@Qualifier(value="backupDataSourceSupplier") Supplier<DataSource> dataSourceSupplier, @Value(value="${liquibase.commit.block.size}") long commitBlockSize) {
        this.commitBlockSize = commitBlockSize;
        this.databaseSession = new LiquibaseSessionThreadLocal(dataSourceSupplier);
    }

    public void beginChangeSet() {
        if (this.databaseSession.getDatabase().supportsDDLInTransaction()) {
            try {
                this.databaseSession.getDatabase().setAutoCommit(false);
            }
            catch (DatabaseException e) {
                throw new LiquibaseDataAccessException("Failed to set auto-commit off", this.databaseSession.getDatabase(), (Throwable)e);
            }
        }
    }

    public void close() {
        this.unlock();
        this.databaseSession.close();
        this.databaseSession.remove();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long countRows(@Nonnull String tableName) {
        Objects.requireNonNull(tableName, "tableName");
        Schema schema = (Schema)this.databaseSession.getSnapshot().get(Schema.class).iterator().next();
        String escapedTableName = this.databaseSession.getDatabase().escapeTableName(schema.getCatalogName(), schema.getName(), tableName);
        Connection connection = LiquibaseUtils.getConnection((Database)this.databaseSession.getDatabase());
        try (Statement statement = connection.createStatement();){
            long l;
            block14: {
                ResultSet resultSet = statement.executeQuery("SELECT count(1) FROM " + escapedTableName);
                try {
                    long l2 = l = resultSet.next() ? resultSet.getLong(1) : 0L;
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw new DataRetrievalFailureException("Could not count rows for " + tableName, (Throwable)e);
        }
    }

    public void createSchema(DataSource dataSource) throws LiquibaseException {
        this.applicationContext.getBean("liquibasePrototype", new Object[]{dataSource});
    }

    public void deleteAllRows(@Nonnull String tableName) {
        DeleteDataChange change = new DeleteDataChange();
        change.setTableName(tableName);
        this.applyChange((Change)change);
        this.commit();
    }

    public void endChangeSet() {
        this.commit();
    }

    public Set<Class<?>> findCustomChanges() {
        return LiquibaseUtils.findCustomChanges();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long forEachRow(@Nonnull String tableName, String orderingColumn, @Nonnull CancelState cancelState, @Nonnull Consumer<Map<String, Object>> operation) {
        Objects.requireNonNull(tableName, "tableName");
        Objects.requireNonNull(operation, "operation");
        Preconditions.checkArgument((orderingColumn == null || StringUtils.isNotBlank((CharSequence)orderingColumn) ? 1 : 0) != 0, (Object)"blank ordering column");
        Table table = new Table();
        table.setName(tableName);
        table = (Table)this.databaseSession.getSnapshot().get((DatabaseObject)table);
        if (table == null) {
            throw new DataRetrievalFailureException("Table " + tableName + " does not exist");
        }
        String escapedTableName = this.databaseSession.getDatabase().escapeTableName(table.getSchema().getCatalogName(), table.getSchema().getName(), tableName);
        Connection connection = LiquibaseUtils.getConnection((Database)this.databaseSession.getDatabase());
        long numberOfRows = 0L;
        try (Statement statement = connection.createStatement();){
            long l;
            block16: {
                statement.setFetchSize(1000);
                ResultSet resultSet = statement.executeQuery("SELECT * FROM " + escapedTableName + this.orderByClause(table, orderingColumn));
                try {
                    while (resultSet.next() && !cancelState.isCanceled()) {
                        this.forCurrentRow(this.databaseSession.getDatabase(), table, resultSet, operation);
                        if (++numberOfRows % 10000L != 0L) continue;
                        log.trace("{}: {} rows processed", (Object)tableName, (Object)numberOfRows);
                    }
                    l = numberOfRows;
                    if (resultSet == null) break block16;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw new DataRetrievalFailureException("Could not fetch rows from " + tableName, (Throwable)e);
        }
    }

    @Nonnull
    public Iterable<String> getColumnNames(@Nonnull String tableName) {
        return (Iterable)this.findTable(tableName).getColumns().stream().map(DefaultLiquibaseSession.TO_LOWERCASE_COLUMN_NAME).collect(MoreCollectors.toImmutableSet());
    }

    @Nonnull
    public String getDatabaseType() {
        return this.databaseSession.getDatabase().getShortName();
    }

    @Nonnull
    public Iterable<String> getTableNames() {
        return (Iterable)this.databaseSession.getSnapshot().get(Table.class).stream().map(DefaultLiquibaseSession.TO_LOWERCASE_TABLE_NAME).filter(((Predicate<String>)tableName -> "databasechangelog".equals(tableName) || "databasechangeloglock".equals(tableName) || "asyncdblock".equals(tableName) || tableName.startsWith("ht_") || tableName.length() == 29 && tableName.startsWith("t_")).negate()).collect(MoreCollectors.toImmutableSet());
    }

    public void insert(@Nonnull InsertDataChange change) {
        List columns = change.getColumns();
        Database database = this.databaseSession.getDatabase();
        StringBuilder builder = new StringBuilder("insert into ").append(database.escapeTableName(change.getCatalogName(), change.getSchemaName(), change.getTableName())).append(" (");
        StringBuilder questions = new StringBuilder();
        for (ColumnConfig column : columns) {
            if (questions.length() > 0) {
                builder.append(", ");
                questions.append(", ");
            }
            builder.append(database.escapeColumnName(change.getCatalogName(), change.getSchemaName(), change.getTableName(), column.getName()));
            questions.append("?");
        }
        builder.append(") values (").append((CharSequence)questions).append(")");
        Connection connection = LiquibaseUtils.getConnection((Database)database);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(builder.toString());
            for (int i = 0; i < columns.size(); ++i) {
                ColumnConfig column = (ColumnConfig)columns.get(i);
                Object value = column.getValueObject();
                if (value instanceof DecodeBase64Function) {
                    value = ((DecodeBase64Function)((Object)value)).decode();
                } else if (value instanceof DatabaseFunction) {
                    log.warn("Unrecognized DatabaseFunction {} for column \"{}\"", value, (Object)column.getName());
                }
                if (value instanceof ColumnConfig.ValueNumeric) {
                    value = ((ColumnConfig.ValueNumeric)value).getDelegate();
                }
                statement.setObject(i + 1, value);
            }
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                log.error("Unable to insert into table {} data {} with statement {}", new Object[]{change.getTableName(), change.getColumns().stream().map(columnConfig -> columnConfig.getName() + "=" + String.valueOf(columnConfig.getValueObject())).collect(Collectors.toList()), builder});
                throw new LiquibaseChangeExecutionException((Change)change, (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(statement);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement((Statement)statement);
        this.commitIfBlockFilled();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void withLock(Consumer<LiquibaseDao> operation) {
        this.lock();
        try {
            operation.accept(this);
        }
        finally {
            this.unlock();
        }
    }

    @VisibleForTesting
    void applyChange(Change change) {
        try {
            change.finishInitialization();
            this.databaseSession.getDatabase().executeStatements(change, EMPTY_CHANGE_LOG, NO_VISITORS);
            log.debug(change.getConfirmationMessage());
            this.databaseSession.incrementChangeCount();
        }
        catch (LiquibaseException e) {
            throw new LiquibaseChangeExecutionException(change, (Throwable)e);
        }
    }

    @VisibleForTesting
    void commit() {
        try {
            this.databaseSession.getDatabase().commit();
            this.databaseSession.resetChangeCount();
        }
        catch (DatabaseException e) {
            throw new LiquibaseDataAccessException("Failed to commit changes to database", this.databaseSession.getDatabase(), (Throwable)e);
        }
    }

    @VisibleForTesting
    void rollback() {
        try {
            this.databaseSession.getDatabase().rollback();
            this.databaseSession.resetChangeCount();
        }
        catch (DatabaseException e) {
            throw new LiquibaseDataAccessException("Failed to rollback changes to database", this.databaseSession.getDatabase(), (Throwable)e);
        }
    }

    @VisibleForTesting
    Object transformValue(Database database, Object value, DataType type) {
        if (database instanceof OracleDatabase) {
            Integer dataType = type.getDataTypeId();
            Integer columnSize = type.getColumnSize();
            if (dataType != null && columnSize != null && dataType == 3 && columnSize == 1 && (BigDecimal.ZERO.equals(value) || BigDecimal.ONE.equals(value))) {
                value = BigDecimal.ONE.equals(value);
            }
        }
        return value;
    }

    private static Predicate<Table> byTableName(String tableName) {
        return table -> table.getName().equalsIgnoreCase(tableName);
    }

    private void commitIfBlockFilled() {
        if (this.commitBlockSize > 0L && this.databaseSession.getChangeCount() >= this.commitBlockSize) {
            this.commit();
        }
    }

    private Table findTable(String tableName) {
        return this.databaseSession.getSnapshot().get(Table.class).stream().filter(DefaultLiquibaseDao.byTableName(tableName)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No table '%s' in database snapshot", tableName)));
    }

    private void forCurrentRow(Database database, Table table, ResultSet resultSet, Consumer<Map<String, Object>> operation) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        HashMap<String, Object> columnValues = new HashMap<String, Object>(columnCount, 1.0f);
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = this.getColumnName(metaData, i);
            columnValues.put(columnName, this.getValue(resultSet, i, database, table.getColumn(columnName)));
        }
        operation.accept(columnValues);
    }

    private String getColumnName(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        return metaData.getColumnName(columnIndex).toLowerCase();
    }

    private Object getValue(ResultSet resultSet, int index, Database database, Column column) throws SQLException {
        return this.transformValue(database, JdbcUtils.getResultSetValue((ResultSet)resultSet, (int)index), column.getType());
    }

    private void lock() {
        log.debug("Locking Liquibase");
        LockService service = this.getLockService(this.databaseSession.getDatabase());
        try {
            service.waitForLock();
            this.lockService = service;
            log.debug("Liquibase locked");
        }
        catch (LockException e) {
            throw new CannotAcquireLockException("Could not lock Liquibase change log", (Throwable)e);
        }
    }

    private String orderByClause(Table table, String column) {
        return column == null ? "" : String.format(" ORDER BY %s ASC", this.databaseSession.getDatabase().escapeColumnName(table.getSchema().getCatalogName(), table.getSchema().getName(), table.getName(), table.getColumn(column).getName()));
    }

    private void unlock() {
        if (this.lockService != null) {
            RELEASE_LOCK.accept(this.lockService);
            this.lockService = null;
        }
    }

    @VisibleForTesting
    LockService getLockService(Database database) {
        StandardLockService lockService = new StandardLockService();
        lockService.setDatabase(database);
        return lockService;
    }
}

