/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.stash.internal.backup.liquibase.DefaultChangeSetIdGenerator;
import com.atlassian.stash.internal.backup.liquibase.DefaultLiquibaseXmlWriter;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseConstants;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDataAccessException;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseXmlWriter;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseXmlWriterFactory;
import com.atlassian.stash.internal.backup.liquibase.xml.DefaultXmlEncoder;
import com.atlassian.stash.internal.backup.liquibase.xml.PrettyXmlWriter;
import jakarta.annotation.Nonnull;
import java.io.OutputStream;
import java.util.Objects;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.springframework.stereotype.Component;

@Component
public class DefaultLiquibaseXmlWriterFactory
implements LiquibaseXmlWriterFactory {
    @Override
    @Nonnull
    public LiquibaseXmlWriter create(@Nonnull OutputStream stream, @Nonnull String author) {
        Objects.requireNonNull(stream, "stream");
        Objects.requireNonNull(author, "author");
        try {
            PrettyXmlWriter delegate = new PrettyXmlWriter(this.newXmlWriter(stream));
            return new DefaultLiquibaseXmlWriter(delegate, new DefaultChangeSetIdGenerator(), author, new DefaultXmlEncoder());
        }
        catch (XMLStreamException e) {
            throw new LiquibaseDataAccessException("An error occurred while writing to the output stream", (Throwable)e);
        }
    }

    protected XMLStreamWriter newXmlWriter(OutputStream stream) throws XMLStreamException {
        return XMLOutputFactory.newInstance().createXMLStreamWriter(stream, LiquibaseConstants.ENCODING);
    }
}

