/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.stash.internal.backup.DatabaseTable;
import com.atlassian.stash.internal.backup.MigrationTarget;
import com.atlassian.stash.internal.backup.liquibase.DefaultLiquibaseDao;
import com.atlassian.stash.internal.backup.liquibase.DefaultLiquibaseSession;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDataAccessException;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseSession;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.DeleteDataChange;
import liquibase.change.core.DropTableChange;
import liquibase.change.core.InsertDataChange;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.LiquibaseException;
import liquibase.structure.core.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.jdbc.support.JdbcUtils;

public class LiquibaseMigrationTarget
implements MigrationTarget {
    public static final String TEST_TABLENAME = "STA_CS_TEST";
    public static final String TEST_COLUMN = "TEST_COLUMN";
    private static final Logger log = LoggerFactory.getLogger(LiquibaseMigrationTarget.class);
    private final LiquibaseSession session;
    private final Connection connection;

    public LiquibaseMigrationTarget(Connection connection) {
        this.connection = connection;
        this.session = new DefaultLiquibaseSession(connection);
    }

    public void close() {
        this.session.close();
    }

    @Override
    public boolean hasNoClashingTables() {
        return this.session.getSnapshot().get(Table.class).stream().map(DefaultLiquibaseSession.TO_LOWERCASE_TABLE_NAME).noneMatch(DatabaseTable.getTableNames()::contains);
    }

    @Override
    public boolean hasRequiredSchemaPermissions() {
        try {
            this.execute(new Change[]{this.createTestTable(), this.insertTestRow("test"), this.deleteTestRow("test"), this.dropTestTable()});
            return true;
        }
        catch (LiquibaseException e) {
            log.debug("Exception thrown when checking schema permissions", (Throwable)e);
            this.executeQuietly(new Change[]{this.dropTestTable()});
            return false;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isCaseSensitive() {
        Statement statement;
        ResultSet resultSet;
        block7: {
            String query;
            block6: {
                resultSet = null;
                statement = null;
                this.execute(new Change[]{this.createTestTable(), this.insertTestRow("SeNsItIvE")});
                query = String.format("SELECT * FROM %s WHERE %s = '%s'", this.escapeTableName(TEST_TABLENAME), this.escapeColumnName(TEST_TABLENAME, TEST_COLUMN), this.escapeString("sensitive"));
                statement = this.connection.createStatement();
                resultSet = statement.executeQuery(query);
                if (!resultSet.next()) break block6;
                boolean bl = false;
                JdbcUtils.closeResultSet((ResultSet)resultSet);
                JdbcUtils.closeStatement((Statement)statement);
                this.executeQuietly(new Change[]{this.dropTestTable()});
                return bl;
            }
            try {
                resultSet.close();
                query = String.format("SELECT * FROM %s WHERE %s = '%s'", this.escapeTableName(TEST_TABLENAME), this.escapeColumnName(TEST_TABLENAME, TEST_COLUMN), this.escapeString("SeNsItIvE"));
                resultSet = statement.executeQuery(query);
                if (resultSet.next()) break block7;
                throw new DataRetrievalFailureException("Failed to retrieve test string from database.");
            }
            catch (LiquibaseException e) {
                try {
                    throw new LiquibaseDataAccessException("Create table failed", (Throwable)e);
                    catch (SQLException e2) {
                        throw new InvalidDataAccessResourceUsageException("Case sensitivity query failed", (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(resultSet);
                    JdbcUtils.closeStatement(statement);
                    this.executeQuietly(new Change[]{this.dropTestTable()});
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeResultSet((ResultSet)resultSet);
        JdbcUtils.closeStatement((Statement)statement);
        this.executeQuietly(new Change[]{this.dropTestTable()});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean isUtf8() {
        block9: {
            database = this.session.getDatabase();
            encodingColumn = 1;
            if (database instanceof OracleDatabase) {
                sql = "select value from nls_database_parameters where parameter='NLS_CHARACTERSET'";
                valid = ImmutableSet.of((Object)"AL32UTF8", (Object)"UTF8");
            } else if (database instanceof PostgresDatabase) {
                sql = "show server_encoding";
                valid = ImmutableSet.of((Object)"UTF8", (Object)"UNICODE");
            } else {
                LiquibaseMigrationTarget.log.warn("UTF8 support cannot be checked for the connected database");
                return true;
            }
            resultSet = null;
            statement = null;
            connection = LiquibaseUtils.getConnection((Database)database);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            if (!resultSet.next()) ** GOTO lbl31
            encoding = resultSet.getString(encodingColumn);
            if (!valid.contains(encoding)) break block9;
            LiquibaseMigrationTarget.log.debug("The database encoding is '{}'", (Object)encoding);
            var9_12 = true;
            JdbcUtils.closeResultSet((ResultSet)resultSet);
            JdbcUtils.closeStatement((Statement)statement);
            return var9_12;
        }
        try {
            block10: {
                LiquibaseMigrationTarget.log.warn("The database encoding is '{}' (Valid: {})", (Object)encoding, (Object)valid);
                break block10;
lbl31:
                // 1 sources

                LiquibaseMigrationTarget.log.warn("The database encoding could not be verified; no rows were returned");
            }
            var8_10 = false;
        }
        catch (SQLException e) {
            try {
                LiquibaseMigrationTarget.log.warn("Failed to confirm UTF-8 support in target database", (Throwable)e);
                var8_11 = true;
            }
            catch (Throwable var10_13) {
                JdbcUtils.closeResultSet(resultSet);
                JdbcUtils.closeStatement((Statement)statement);
                throw var10_13;
            }
            JdbcUtils.closeResultSet((ResultSet)resultSet);
            JdbcUtils.closeStatement((Statement)statement);
            return var8_11;
        }
        JdbcUtils.closeResultSet((ResultSet)resultSet);
        JdbcUtils.closeStatement((Statement)statement);
        return var8_10;
    }

    private ColumnConfig createTestColumn() {
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setType("VARCHAR(255)");
        columnConfig.setName(TEST_COLUMN);
        return columnConfig;
    }

    private CreateTableChange createTestTable() {
        CreateTableChange create = new CreateTableChange();
        create.setSchemaName(this.session.getDatabase().getDefaultSchemaName());
        create.setTableName(TEST_TABLENAME);
        create.addColumn(this.createTestColumn());
        return create;
    }

    private DeleteDataChange deleteTestRow(String value) {
        ColumnConfig column = this.createTestColumn();
        column.setValue(value);
        DeleteDataChange delete = new DeleteDataChange();
        delete.setTableName(TEST_TABLENAME);
        delete.setWhere(String.format("%s = '%s'", this.escapeColumnName(TEST_TABLENAME, TEST_COLUMN), this.escapeString(value)));
        return delete;
    }

    private DropTableChange dropTestTable() {
        DropTableChange drop = new DropTableChange();
        drop.setSchemaName(this.session.getDatabase().getDefaultSchemaName());
        drop.setTableName(TEST_TABLENAME);
        return drop;
    }

    private String escapeTableName(String table) {
        return LiquibaseUtils.escapeTableName((Database)this.session.getDatabase(), (String)table);
    }

    private String escapeColumnName(String table, String column) {
        return LiquibaseUtils.escapeColumnName((Database)this.session.getDatabase(), (String)table, (String)column);
    }

    private String escapeString(String value) {
        return this.session.getDatabase().escapeStringForDatabase(value);
    }

    private void execute(Change ... changes) throws LiquibaseException {
        for (Change change : changes) {
            this.session.getDatabase().executeStatements(change, DefaultLiquibaseDao.EMPTY_CHANGE_LOG, DefaultLiquibaseDao.NO_VISITORS);
        }
    }

    private void executeQuietly(Change ... changes) {
        for (Change change : changes) {
            try {
                this.execute(change);
            }
            catch (LiquibaseException e) {
                log.debug("Change execution failed", (Throwable)e);
            }
        }
    }

    private InsertDataChange insertTestRow(String value) {
        InsertDataChange insert = new InsertDataChange();
        insert.setTableName(TEST_TABLENAME);
        ColumnConfig column = this.createTestColumn();
        column.setValue(value);
        insert.addColumn(column);
        return insert;
    }
}

