/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.stash.internal.backup.liquibase.DefaultLiquibaseSession;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseSession;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Supplier;
import javax.sql.DataSource;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.snapshot.DatabaseSnapshot;

class LiquibaseSessionThreadLocal
extends ThreadLocal<LiquibaseSession>
implements LiquibaseSession {
    private final Supplier<DataSource> dataSourceSupplier;

    LiquibaseSessionThreadLocal(Supplier<DataSource> dataSourceSupplier) {
        this.dataSourceSupplier = Objects.requireNonNull(dataSourceSupplier, "dataSourceSupplier");
    }

    @Override
    protected DefaultLiquibaseSession initialValue() {
        return new DefaultLiquibaseSession(this.dataSourceSupplier.get());
    }

    @Override
    public Database getDatabase() {
        return ((LiquibaseSession)this.get()).getDatabase();
    }

    @Override
    public DatabaseSnapshot getSnapshot() {
        return ((LiquibaseSession)this.get()).getSnapshot();
    }

    @Override
    public void resetChangeCount() {
        ((LiquibaseSession)this.get()).resetChangeCount();
    }

    @Override
    public void incrementChangeCount() {
        ((LiquibaseSession)this.get()).incrementChangeCount();
    }

    @Override
    public long getChangeCount() {
        return ((LiquibaseSession)this.get()).getChangeCount();
    }

    @Override
    public void close() {
        ((LiquibaseSession)this.get()).close();
    }

    @Override
    @Nonnull
    public DataTypeFactory getDataTypeFactory() {
        return ((LiquibaseSession)this.get()).getDataTypeFactory();
    }
}

