/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.stash.internal.backup.liquibase.LiquibaseBackupMonitor;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDataAccessException;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseXmlWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;
import liquibase.change.core.InsertDataChange;

class WriteXmlForRowConsumer
implements Consumer<Map<String, Object>> {
    private static final String CHANGE_NAME = new InsertDataChange().createChangeMetaData().getName();
    private final String tableName;
    private final Iterable<String> columnNames;
    private final LiquibaseBackupMonitor monitor;
    private final LiquibaseXmlWriter writer;

    WriteXmlForRowConsumer(LiquibaseXmlWriter writer, String tableName, Iterable<String> columnNames, LiquibaseBackupMonitor monitor) {
        this.writer = writer;
        this.tableName = tableName;
        this.columnNames = columnNames;
        this.monitor = monitor;
    }

    @Override
    public void accept(Map<String, Object> row) {
        Preconditions.checkArgument((!row.keySet().contains(null) ? 1 : 0) != 0, (Object)"Column names must not be null");
        try {
            this.writer.writeStartElement(CHANGE_NAME);
            this.writer.writeAttribute("tableName", this.tableName.toLowerCase());
            this.writeRow(this.columnNames, row);
            this.writer.writeEndElement();
            this.monitor.rowWritten();
        }
        catch (XMLStreamException e) {
            throw new LiquibaseDataAccessException("An error occurred while writing to the output stream", (Throwable)e);
        }
    }

    private Map<String, Object> toLowerCaseKeys(Map<String, Object> row) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            result.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return result;
    }

    private void writeRow(Iterable<String> columnNames, Map<String, Object> row) throws XMLStreamException {
        Map<String, Object> rowWithLowerCaseKeys = this.toLowerCaseKeys(row);
        for (String columnName : columnNames) {
            this.writer.writeColumn(columnName.toLowerCase(), rowWithLowerCaseKeys.get(columnName.toLowerCase()));
        }
    }
}

