/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase.processors;

import com.atlassian.stash.internal.backup.liquibase.processors.ChangeSetProcessor;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import liquibase.change.core.DeleteDataChange;
import liquibase.change.core.InsertDataChange;
import liquibase.changelog.ChangeSet;

public class CompositeChangeSetProcessor
implements ChangeSetProcessor {
    private final Collection<ChangeSetProcessor> processors;

    public CompositeChangeSetProcessor(ChangeSetProcessor ... processors) {
        this.processors = ImmutableList.copyOf((Object[])Objects.requireNonNull(processors, "processors"));
    }

    @Override
    public void onChangesetBegin(ChangeSet changeSet) {
        for (ChangeSetProcessor processor : this.processors) {
            processor.onChangesetBegin(changeSet);
        }
    }

    @Override
    public void onChangesetContent(InsertDataChange change) {
        for (ChangeSetProcessor processor : this.processors) {
            processor.onChangesetContent(change);
        }
    }

    @Override
    public void onChangesetContent(DeleteDataChange change) {
        for (ChangeSetProcessor processor : this.processors) {
            processor.onChangesetContent(change);
        }
    }

    @Override
    public void onChangesetComplete(ChangeSet changeSet) {
        for (ChangeSetProcessor processor : this.processors) {
            processor.onChangesetComplete(changeSet);
        }
    }
}

