/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.comment.CommentCounts;
import com.atlassian.stash.internal.comment.CommentDao;
import com.atlassian.stash.internal.comment.CommentSearchCriteria;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.content.InternalChangeLocation;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.util.LikeQueryHelper;
import com.atlassian.stash.internal.util.NumberBuffer;
import com.atlassian.stash.internal.util.ScrollableResultsHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.LongStream;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.CacheMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.hibernate.type.IntegerType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="commentDao")
public class HibernateCommentDao
extends AbstractHibernateDao<Long, InternalComment>
implements CommentDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = List.of(HqlQueryBuilder.HqlQueryOrder.asc((String)"createdDate"), HqlQueryBuilder.HqlQueryOrder.asc((String)"id"));
    private final int queryDisjunctionSize;

    @Autowired
    public HibernateCommentDao(SessionFactory sessionFactory) {
        super(sessionFactory);
        this.queryDisjunctionSize = 100;
    }

    public long count(@Nonnull CommentSearchCriteria searchCriteria) {
        return (Long)HqlQueryBuilder.selectPropertiesFrom(InternalComment.class, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.rowCount()}).where((HqlQueryBuilder.HqlWhereQueryComponent)HibernateCommentDao.getConditionals(searchCriteria)).buildQuery(this.session(), Long.class).uniqueResult();
    }

    @Nonnull
    public Map<String, Long> countByCommit(int repositoryId, @Nonnull Set<String> commitIds) {
        List list = this.session().createQuery("select thread.anchor.toHash, count(*) from InternalComment where thread.anchor.toHash in (:commitIds) and thread.commentable.class = :class and thread.commentable.id in (select id from InternalCommitDiscussion where repository.id = :repositoryId ) group by thread.anchor.toHash").setParameter("class", (Object)1, (Type)IntegerType.INSTANCE).setParameter("repositoryId", (Object)repositoryId).setParameterList("commitIds", commitIds).list();
        return (Map)list.stream().collect(MoreCollectors.toImmutableMap(row -> (String)row[0], row -> ((Number)row[1]).longValue()));
    }

    @Nonnull
    public Map<String, Long> countByPullRequestCommit(long pullRequestGlobalId, @Nonnull Set<String> commitIds) {
        List list = this.session().createQuery("select thread.anchor.toHash, count(*) from InternalComment where thread.commentable.class = :class and thread.commentable.id = :pullRequestId and thread.anchor.toHash in :commitIds and thread.anchor.diffType = :diffType and state <> :pending group by thread.anchor.toHash").setParameter("class", (Object)2, (Type)IntegerType.INSTANCE).setParameter("pullRequestId", (Object)pullRequestGlobalId).setParameterList("commitIds", commitIds).setParameter("diffType", (Object)CommentThreadDiffAnchorType.COMMIT).setParameter("pending", (Object)CommentState.PENDING).list();
        return (Map)list.stream().collect(MoreCollectors.toImmutableMap(row -> (String)row[0], row -> ((Number)row[1]).longValue()));
    }

    @Nonnull
    public Map<Long, Long> countByPullRequest(@Nonnull Set<Long> pullRequestIds, @Nonnull List<CommentSeverity> commentSeverities, @Nonnull List<CommentState> commentStates) {
        ImmutableMap.Builder results = ImmutableMap.builder();
        Iterables.partition(pullRequestIds, (int)this.queryDisjunctionSize).forEach(batch -> {
            HqlQueryBuilder builder = HqlQueryBuilder.selectPropertiesFrom(InternalComment.class, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.property((String)"thread.commentable.id"), HqlQueryBuilder.rowCount()});
            HqlQueryBuilder.HqlWhereConditionalQueryComponent ands = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"thread.commentable.class", (Object)InternalPullRequest.class.getName()), HqlQueryBuilder.HqlWhereQueryComponent.in((String)"thread.commentable.id", (Collection)batch)});
            if (!commentSeverities.isEmpty()) {
                ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.in((String)"severity", (Collection)commentSeverities)});
            }
            if (!commentStates.isEmpty()) {
                ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.in((String)"state", (Collection)commentStates)});
            }
            builder.where((HqlQueryBuilder.HqlWhereQueryComponent)ands).groupBy(new String[]{"thread.commentable.id"});
            Query query = builder.buildQuery(this.session(), Object[].class);
            query.list().forEach(row -> results.put((Object)((Number)row[0]).longValue(), (Object)((Number)row[1]).longValue()));
        });
        return results.build();
    }

    @Nonnull
    public Map<CommentState, Long> countByState(@Nonnull CommentSearchCriteria searchCriteria) {
        ImmutableMap.Builder results = ImmutableMap.builder();
        HqlQueryBuilder builder = HqlQueryBuilder.selectPropertiesFrom(InternalComment.class, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.property((String)"state"), HqlQueryBuilder.rowCount()}).groupBy(new String[]{"state"});
        builder.where((HqlQueryBuilder.HqlWhereQueryComponent)HibernateCommentDao.getConditionals(searchCriteria));
        Query query = builder.buildQuery(this.session(), Object[].class);
        query.list().forEach(row -> results.put((Object)((CommentState)row[0]), (Object)((Number)row[1]).longValue()));
        return results.build();
    }

    public long countOther(@Nonnull CommentSearchCriteria searchCriteria) {
        HqlQueryBuilder builder = HqlQueryBuilder.selectPropertiesFrom(InternalComment.class, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.rowCount()});
        HqlQueryBuilder.HqlWhereConditionalQueryComponent ands = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"thread.commentable", (Object)searchCriteria.getCommentable())});
        HqlQueryBuilder.HqlWhereConditionalQueryComponent buildRestrictions = HibernateCommentDao.buildRestrictions(searchCriteria);
        if (!buildRestrictions.isEmpty()) {
            ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.not((HqlQueryBuilder.HqlWhereQueryComponent)buildRestrictions)});
        }
        searchCriteria.getPath().map(HibernateCommentDao.toEqual("thread.anchor.path")).ifPresent(xva$0 -> ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{xva$0}));
        HibernateCommentDao.maybeAddCommentStateConditions(ands, searchCriteria);
        builder.where((HqlQueryBuilder.HqlWhereQueryComponent)ands);
        return (Long)builder.buildQuery(this.session(), Long.class).uniqueResult();
    }

    @Nonnull
    public Map<InternalChangeLocation, CommentCounts> countsByLocation(@Nonnull CommentSearchCriteria searchCriteria) {
        HqlQueryBuilder builder = HqlQueryBuilder.selectPropertiesFrom(InternalComment.class, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.property((String)"thread.anchor.path"), HqlQueryBuilder.property((String)"thread.anchor.srcPath"), HqlQueryBuilder.property((String)"thread.anchor.orphaned"), HqlQueryBuilder.rowCount()}).groupBy(new String[]{"thread.anchor.path", "thread.anchor.srcPath", "thread.anchor.orphaned"}).orderBy(new HqlQueryBuilder.HqlQueryOrder[]{HqlQueryBuilder.HqlQueryOrder.asc((String)"thread.anchor.path"), HqlQueryBuilder.HqlQueryOrder.asc((String)"thread.anchor.srcPath")});
        HqlQueryBuilder.HqlWhereConditionalQueryComponent conditionals = HibernateCommentDao.getConditionals(new CommentSearchCriteria.Builder(searchCriteria).anchorState(CommentThreadDiffAnchorState.ACTIVE).build());
        builder.where((HqlQueryBuilder.HqlWhereQueryComponent)conditionals);
        Query query = builder.buildQuery(this.session(), Object[].class);
        return HibernateCommentDao.mapCounts(query.list());
    }

    @Nonnull
    public InternalComment create(InternalComment entity) {
        return this.create(entity, !entity.isPending());
    }

    public void delete(InternalComment entity) {
        InternalComment parent = entity.getParent();
        if (parent != null) {
            parent.removeComment(entity);
            this.session().update((Object)parent);
        }
        super.delete((Object)entity);
        if (parent != null && !entity.isPending()) {
            this.updateThread(entity);
        }
    }

    public boolean deleteBatch(@Nonnull List<InternalComment> batch) {
        Session session = this.session();
        batch.forEach(comment -> {
            InternalComment parent = comment.getParent();
            if (parent == null) {
                session.delete((Object)comment.getThread());
            } else {
                parent.removeComment(comment);
                session.update((Object)parent);
                session.delete(comment);
            }
        });
        session.flush();
        session.clear();
        return true;
    }

    public InternalComment getById(Long id) {
        return HibernateCommentDao.initialize((InternalComment)super.getById((Serializable)id));
    }

    @Nonnull
    public InternalComment importComment(@Nonnull InternalComment entity) {
        InternalComment created = this.create(entity, false);
        this.session().flush();
        return created;
    }

    @Nonnull
    public Page<InternalComment> search(@Nonnull CommentSearchCriteria searchCriteria, PageRequest pageRequest) {
        HqlQueryBuilder builder = HqlQueryBuilder.selectFrom(InternalComment.class).where((HqlQueryBuilder.HqlWhereQueryComponent)HibernateCommentDao.getConditionals(searchCriteria)).orderBy(new HqlQueryBuilder.HqlQueryOrder[]{HqlQueryBuilder.HqlQueryOrder.asc((String)"id")});
        return HibernateCommentDao.initializePage((Page<InternalComment>)this.pageQuery(builder.buildQuery(this.session()), pageRequest));
    }

    @Nonnull
    public LongStream streamIds(@Nonnull String textContains) {
        Query query = this.session().createQuery("select id from InternalComment where lower(text) like lower(:pattern) escape '!' order by id asc", Long.class);
        query.setParameter("pattern", (Object)LikeQueryHelper.matchesAnywhere(this.session(), textContains));
        query.setCacheMode(CacheMode.IGNORE);
        try (ScrollableResults results = query.scroll(ScrollMode.FORWARD_ONLY);){
            LongStream longStream = NumberBuffer.buffer(ScrollableResultsHelper.scrollableResultsToLongStream(results));
            return longStream;
        }
    }

    public InternalComment update(InternalComment entity) {
        return HibernateCommentDao.initialize((InternalComment)super.update((Object)entity));
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }

    static HqlQueryBuilder.HqlWhereConditionalQueryComponent transformCommentStateConditionsToQueryComponent(CommentSearchCriteria searchCriteria, @Nullable String alias) {
        HqlQueryBuilder.HqlWhereConditionalQueryComponent ands = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[0]);
        if (searchCriteria.hasStates()) {
            Object prefix = StringUtils.isEmpty((CharSequence)alias) ? "" : alias + ".";
            Set states = searchCriteria.getStates();
            if (states.contains(CommentState.PENDING) && (searchCriteria.omitPendingComments() || searchCriteria.getPendingAuthor().isPresent())) {
                HqlQueryBuilder.HqlWhereQueryComponent pendingFilter = searchCriteria.omitPendingComments() ? HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)((String)prefix + "author")) : HqlQueryBuilder.HqlWhereQueryComponent.equal((String)((String)prefix + "author"), searchCriteria.getPendingAuthor().get());
                HqlQueryBuilder.HqlWhereConditionalQueryComponent and = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)((String)prefix + "state"), (Object)CommentState.PENDING), pendingFilter});
                HashSet remaining = new HashSet(states);
                remaining.remove(CommentState.PENDING);
                if (remaining.isEmpty()) {
                    ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{and});
                } else {
                    ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{and, HqlQueryBuilder.HqlWhereQueryComponent.in((String)((String)prefix + "state"), remaining)})});
                }
            } else {
                ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.in((String)((String)prefix + "state"), (Collection)states)});
            }
        }
        return ands;
    }

    private static void maybeAddCommentStateConditions(HqlQueryBuilder.HqlWhereConditionalQueryComponent conditionals, CommentSearchCriteria searchCriteria) {
        if (searchCriteria.hasStates()) {
            Set states = searchCriteria.getStates();
            if (states.contains(CommentState.PENDING) && (searchCriteria.omitPendingComments() || searchCriteria.getPendingAuthor().isPresent())) {
                HqlQueryBuilder.HqlWhereQueryComponent pendingFilter = searchCriteria.omitPendingComments() ? HqlQueryBuilder.HqlWhereQueryComponent.isNull((String)"author") : HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"author", searchCriteria.getPendingAuthor().get());
                HqlQueryBuilder.HqlWhereConditionalQueryComponent pending = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"state", (Object)CommentState.PENDING), pendingFilter});
                HashSet remaining = new HashSet(states);
                remaining.remove(CommentState.PENDING);
                if (remaining.isEmpty()) {
                    conditionals.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{pending});
                } else {
                    conditionals.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.or((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{pending, HqlQueryBuilder.HqlWhereQueryComponent.in((String)"state", remaining)})});
                }
            } else {
                conditionals.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.in((String)"state", (Collection)states)});
            }
        }
    }

    private static Map<InternalChangeLocation, CommentCounts> mapCounts(List<Object[]> results) {
        if (results.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<InternalChangeLocation, CommentCounts> countsByLocation = new HashMap<InternalChangeLocation, CommentCounts>(results.size(), 1.0f);
        for (int i = 0; i < results.size(); ++i) {
            CountHelper helper = new CountHelper(results.get(i));
            int next = i + 1;
            if (next < results.size() && helper.merge(results.get(next))) {
                i = next;
            }
            countsByLocation.put(helper.getLocation(), helper.getCounts());
        }
        return countsByLocation;
    }

    private static InternalComment initialize(InternalComment comment) {
        if (comment == null) {
            return null;
        }
        HibernateUtils.initialize((Object)comment.getThread());
        return comment;
    }

    private static Page<InternalComment> initializePage(Page<InternalComment> page) {
        if (page == null) {
            return null;
        }
        return page.transform(HibernateCommentDao::initialize);
    }

    private static HqlQueryBuilder.HqlWhereConditionalQueryComponent buildRestrictions(CommentSearchCriteria searchCriteria) {
        HqlQueryBuilder.HqlWhereConditionalQueryComponent ands = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[0]);
        searchCriteria.getToHash().map(HibernateCommentDao.toEqual("thread.anchor.toHash")).ifPresent(xva$0 -> ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{xva$0}));
        searchCriteria.getFromHash().map(HibernateCommentDao.toEqual("thread.anchor.fromHash")).ifPresent(xva$0 -> ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{xva$0}));
        if (searchCriteria.hasDiffTypes()) {
            ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.in((String)"thread.anchor.diffType", (Collection)searchCriteria.getDiffTypes())});
        }
        if (searchCriteria.getAnchorState() != CommentThreadDiffAnchorState.ALL) {
            ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"thread.anchor.orphaned", (Object)(searchCriteria.getAnchorState() == CommentThreadDiffAnchorState.ORPHANED ? 1 : 0))});
        }
        return ands;
    }

    private InternalComment create(InternalComment entity, boolean updateThread) {
        InternalComment created = (InternalComment)super.create((Object)entity);
        InternalComment parent = created.getParent();
        if (parent != null) {
            parent.addComment(created);
            this.session().update((Object)parent);
            if (updateThread) {
                this.updateThread(entity);
            }
        }
        return created;
    }

    private static HqlQueryBuilder.HqlWhereConditionalQueryComponent getConditionals(CommentSearchCriteria searchCriteria) {
        HqlQueryBuilder.HqlWhereConditionalQueryComponent buildRestrictions;
        HqlQueryBuilder.HqlWhereConditionalQueryComponent ands = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"thread.commentable", (Object)searchCriteria.getCommentable())});
        searchCriteria.getAuthor().map(HibernateCommentDao.toEqual("author")).ifPresent(xva$0 -> ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{xva$0}));
        searchCriteria.getPath().map(HibernateCommentDao.toEqual("thread.anchor.path")).ifPresent(xva$0 -> ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{xva$0}));
        if (searchCriteria.hasSeverities()) {
            ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.in((String)"severity", (Collection)searchCriteria.getSeverities())});
        }
        if (!(buildRestrictions = HibernateCommentDao.buildRestrictions(searchCriteria)).isEmpty()) {
            ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{buildRestrictions});
        }
        HibernateCommentDao.maybeAddCommentStateConditions(ands, searchCriteria);
        return ands;
    }

    private static Function<Object, HqlQueryBuilder.HqlWhereQueryComponent> toEqual(String key) {
        return value -> HqlQueryBuilder.HqlWhereQueryComponent.equal((String)key, (Object)value);
    }

    private void updateThread(InternalComment comment) {
        this.session().createQuery("update InternalCommentThread set updatedDate = (select max(createdDate) from InternalComment where thread.id = :threadId) where id = :threadId").setParameter("threadId", (Object)comment.getThread().getId()).executeUpdate();
    }

    private static class CountHelper {
        private final String path;
        private final String srcPath;
        private int activeCount;
        private int orphanedCount;

        private CountHelper(Object[] columns) {
            this.path = (String)columns[0];
            this.srcPath = (String)columns[1];
            this.setCountFrom(columns);
        }

        private CommentCounts getCounts() {
            return new CommentCounts(this.activeCount, this.orphanedCount);
        }

        private InternalChangeLocation getLocation() {
            return new InternalChangeLocation.Builder().path(this.path).srcPath(this.srcPath).build();
        }

        private boolean merge(Object[] columns) {
            if (this.path.equals(columns[0]) && Objects.equals(this.srcPath, columns[1])) {
                this.setCountFrom(columns);
                return true;
            }
            return false;
        }

        private void setCountFrom(Object[] columns) {
            int count = ((Number)columns[3]).intValue();
            if (((Boolean)columns[2]).booleanValue()) {
                this.orphanedCount = count;
            } else {
                this.activeCount = count;
            }
        }
    }
}

