/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorState;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.comment.CommentSearchCriteria;
import com.atlassian.stash.internal.comment.CommentThreadDao;
import com.atlassian.stash.internal.comment.HibernateCommentDao;
import com.atlassian.stash.internal.comment.InternalCommentThread;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="commentThreadDao")
public class HibernateCommentThreadDao
extends AbstractHibernateDao<Long, InternalCommentThread>
implements CommentThreadDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = List.of(HqlQueryBuilder.HqlQueryOrder.desc((String)"updatedDate"), HqlQueryBuilder.HqlQueryOrder.desc((String)"id"));

    @Autowired
    public HibernateCommentThreadDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public long count(@Nonnull CommentSearchCriteria searchCriteria) {
        HqlQueryBuilder hqlQueryBuilder = HqlQueryBuilder.selectPropertiesFrom(InternalCommentThread.class, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.rowCount()});
        hqlQueryBuilder.where((HqlQueryBuilder.HqlWhereQueryComponent)HibernateCommentThreadDao.getCommentSearchConditions(searchCriteria));
        return (Long)hqlQueryBuilder.buildQuery(this.session(), Long.class).uniqueResult();
    }

    public void deleteByIds(@Nonnull List<Long> threadIds) {
        if (threadIds.isEmpty()) {
            return;
        }
        for (List partition : Lists.partition(threadIds, (int)200)) {
            this.session().createQuery("delete from InternalComment where thread.id in (:threadIds) and parent is not null").setParameterList("threadIds", (Collection)partition).executeUpdate();
            this.session().createQuery("delete from InternalCommentThread where id in (:threadIds)").setParameterList("threadIds", (Collection)partition).executeUpdate();
        }
    }

    @Nonnull
    public InternalCommentThread importThread(@Nonnull InternalCommentThread entity) {
        entity = (InternalCommentThread)this.create(entity);
        this.session().flush();
        return entity;
    }

    @Nonnull
    public List<InternalCommentThread> search(@Nonnull CommentSearchCriteria searchCriteria) {
        HqlQueryBuilder hqlQueryBuilder = HqlQueryBuilder.selectFrom(InternalCommentThread.class).where((HqlQueryBuilder.HqlWhereQueryComponent)HibernateCommentThreadDao.getCommentSearchConditions(searchCriteria)).orderBy(new HqlQueryBuilder.HqlQueryOrder[]{HqlQueryBuilder.HqlQueryOrder.asc((String)"anchor.line"), HqlQueryBuilder.HqlQueryOrder.asc((String)"updatedDate")});
        return hqlQueryBuilder.buildQuery(this.session(), InternalCommentThread.class).list();
    }

    @Nonnull
    public Page<InternalCommentThread> search(@Nonnull CommentSearchCriteria searchCriteria, @Nonnull PageRequest pageRequest) {
        HqlQueryBuilder hqlQueryBuilder = HqlQueryBuilder.selectFrom(InternalCommentThread.class).where((HqlQueryBuilder.HqlWhereQueryComponent)HibernateCommentThreadDao.getCommentSearchConditions(searchCriteria)).orderBy(new HqlQueryBuilder.HqlQueryOrder[]{HqlQueryBuilder.HqlQueryOrder.asc((String)"anchor.line"), HqlQueryBuilder.HqlQueryOrder.asc((String)"updatedDate")});
        return HibernateUtils.initializePage((Page)this.pageQuery(hqlQueryBuilder.buildQuery(this.session(), InternalCommentThread.class), pageRequest));
    }

    private static HqlQueryBuilder.HqlWhereConditionalQueryComponent getAnchorConditions(CommentSearchCriteria searchCriteria) {
        CommentThreadDiffAnchorState anchorState;
        HqlQueryBuilder.HqlWhereConditionalQueryComponent ands = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[0]);
        searchCriteria.getToHash().ifPresent(toHash -> ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"anchor.toHash", (Object)toHash)}));
        searchCriteria.getFromHash().ifPresent(fromHash -> ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"anchor.fromHash", (Object)fromHash)}));
        if (searchCriteria.hasDiffTypes()) {
            ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.in((String)"anchor.diffType", (Collection)searchCriteria.getDiffTypes())});
        }
        if ((anchorState = searchCriteria.getAnchorState()) == CommentThreadDiffAnchorState.ALL) {
            ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.isNotNull((String)"anchor.orphaned")});
        } else {
            ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"anchor.orphaned", (Object)(anchorState == CommentThreadDiffAnchorState.ORPHANED ? 1 : 0))});
        }
        return ands;
    }

    private static HqlQueryBuilder.HqlWhereConditionalQueryComponent getCommentSearchConditions(CommentSearchCriteria searchCriteria) {
        String rootCommentAlias = "rootComment";
        HqlQueryBuilder.HqlWhereConditionalQueryComponent ands = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"commentable", (Object)searchCriteria.getCommentable()), HqlQueryBuilder.HqlWhereQueryComponent.isNotNull((String)rootCommentAlias)});
        searchCriteria.getAuthor().ifPresent(author -> ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)(rootCommentAlias + ".author"), (Object)author)}));
        searchCriteria.getPath().ifPresent(path -> ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"anchor.path", (Object)path)}));
        ands.addAll(HibernateCommentThreadDao.getAnchorConditions(searchCriteria));
        ands.addAll(HibernateCommentDao.transformCommentStateConditionsToQueryComponent(searchCriteria, rootCommentAlias));
        return ands;
    }

    @Nonnull
    public Page<InternalCommentThread> searchOther(@Nonnull CommentSearchCriteria searchCriteria, @Nonnull PageRequest pageRequest) {
        String rootCommentAlias = "rootComment";
        HqlQueryBuilder.HqlWhereConditionalQueryComponent ands = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"commentable", (Object)searchCriteria.getCommentable()), HqlQueryBuilder.HqlWhereQueryComponent.isNotNull((String)rootCommentAlias)});
        searchCriteria.getPath().ifPresent(path -> ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"anchor.path", (Object)path)}));
        ands.addAll(HibernateCommentDao.transformCommentStateConditionsToQueryComponent(searchCriteria, rootCommentAlias));
        HqlQueryBuilder.HqlWhereConditionalQueryComponent negatedConditions = HqlQueryBuilder.HqlWhereQueryComponent.and((HqlQueryBuilder.HqlWhereQueryComponent[])new HqlQueryBuilder.HqlWhereQueryComponent[0]);
        negatedConditions.addAll(HibernateCommentThreadDao.getAnchorConditions(searchCriteria));
        ands.add(new HqlQueryBuilder.HqlWhereQueryComponent[]{HqlQueryBuilder.HqlWhereQueryComponent.not((HqlQueryBuilder.HqlWhereQueryComponent)negatedConditions)});
        HqlQueryBuilder hqlQueryBuilder = HqlQueryBuilder.selectFrom(InternalCommentThread.class);
        hqlQueryBuilder.where((HqlQueryBuilder.HqlWhereQueryComponent)ands);
        hqlQueryBuilder.orderBy(new HqlQueryBuilder.HqlQueryOrder[]{HqlQueryBuilder.HqlQueryOrder.asc((String)"anchor.line"), HqlQueryBuilder.HqlQueryOrder.asc((String)"updatedDate")});
        return HibernateUtils.initializePage((Page)this.pageQuery(hqlQueryBuilder.buildQuery(this.session(), InternalCommentThread.class), pageRequest));
    }

    @Nonnull
    public Page<InternalCommentThread> searchPending(@Nonnull InternalCommentable commentable, int userId, @Nonnull PageRequest pageRequest) {
        String idHql = "select distinct c.thread.id from InternalComment c where c.author.id = :authorId and c.state = :pending and c.thread.commentable = :commentable";
        String threadHql = "from InternalCommentThread t where t.id in (" + idHql + ") order by t.updatedDate desc";
        Query query = this.session().createQuery(threadHql, InternalCommentThread.class).setParameter("authorId", (Object)userId).setParameter("commentable", (Object)commentable).setParameter("pending", (Object)CommentState.PENDING);
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

