/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.bitbucket.idx.IndexSearchRequest;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageImpl;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.content.IndexedCommitDao;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.idx.InternalCommitAttribute;
import com.atlassian.stash.internal.idx.InternalIndexedCommit;
import com.atlassian.stash.internal.idx.InternalRepositoryMembership;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository(value="indexedCommitDao")
public class HibernateIndexedCommitDao
extends AbstractHibernateDao<String, InternalIndexedCommit>
implements IndexedCommitDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = List.of(HqlQueryBuilder.HqlQueryOrder.desc((String)"authorTimestamp"), HqlQueryBuilder.HqlQueryOrder.desc((String)"id"));
    private final boolean mssqlClusteredIndexOverride;
    private final RepositoryDao repositoryDao;

    @Autowired
    public HibernateIndexedCommitDao(@Value(value="${mssql.cs_attribute.index.clustered.force:false}") String mssqlClusteredIndexOverride, SessionFactory sessionFactory, RepositoryDao repositoryDao) {
        super(sessionFactory);
        this.mssqlClusteredIndexOverride = Boolean.parseBoolean(mssqlClusteredIndexOverride);
        this.repositoryDao = repositoryDao;
    }

    public boolean addMembership(@Nonnull InternalIndexedCommit commit, @Nonnull InternalRepository repository) {
        InternalRepositoryMembership membership = this.getMembership(commit.getId(), repository);
        if (membership == null) {
            this.session().save((Object)new InternalRepositoryMembership(commit, repository));
            return true;
        }
        return false;
    }

    public boolean addProperty(@Nonnull InternalIndexedCommit commit, @Nonnull String key, @Nonnull String value) {
        boolean result = commit.addAttribute(new InternalCommitAttribute(key, value));
        this.session().update((Object)commit);
        return result;
    }

    @Nonnull
    public InternalIndexedCommit create(InternalIndexedCommit entity) {
        return (InternalIndexedCommit)HibernateUtils.initialize((Object)((InternalIndexedCommit)super.create((Object)entity)));
    }

    public void deleteAllMemberships(@Nonnull InternalRepository repository) {
        this.session().createQuery("DELETE from InternalRepositoryMembership where repository = :repositoryId").setParameter("repositoryId", (Object)repository).executeUpdate();
    }

    public boolean deleteMembership(@Nonnull String commitId, @Nonnull InternalRepository repository) {
        InternalRepositoryMembership membership = this.getMembership(commitId, repository);
        if (membership != null) {
            this.session().delete((Object)membership);
            InternalIndexedCommit commit = membership.getCommit();
            Set memberships = commit.getRepositoryMemberships();
            memberships.remove(membership);
            if (memberships.isEmpty()) {
                this.delete(membership.getCommit());
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public Page<InternalIndexedCommit> findAll(PageRequest pageRequest) {
        return HibernateUtils.initializePage((Page)super.findAll(pageRequest));
    }

    @Nonnull
    public Page<InternalIndexedCommit> findAll(PageRequest pageRequest, Predicate<? super InternalIndexedCommit> predicate) {
        return HibernateUtils.initializePage((Page)super.findAll(pageRequest, predicate));
    }

    @Nonnull
    public Page<InternalIndexedCommit> findByProperty(String key, String value, boolean caseSensitive, PageRequest pageRequest) {
        if (this.isSqlServer() && this.mssqlClusteredIndexOverride) {
            String query = "select * from changeset cs inner join cs_attribute att with(index(0)) on cs.id=att.cs_id and (" + (caseSensitive ? "att.att_value = :value" : "lower(att.att_value) = lower(:value)") + " and att.att_name = :key ) ORDER BY cs.author_timestamp DESC";
            return HibernateUtils.initializePage((Page)this.pageQuery((Query)this.session().createNativeQuery(query, InternalIndexedCommit.class).setParameter("key", (Object)key).setParameter("value", (Object)value), pageRequest));
        }
        return HibernateUtils.initializePage((Page)this.pageQuery(this.session().createQuery("FROM InternalIndexedCommit c JOIN c.attributes att WITH " + (caseSensitive ? "att.value = :value " : "lower(att.value) = lower(:value) ") + " AND att.name = :name ORDER BY c.authorTimestamp DESC").setParameter("name", (Object)key).setParameter("value", (Object)value), pageRequest));
    }

    @Nonnull
    public Page<InternalIndexedCommit> findByPropertyWithRepository(String key, String value, boolean caseSensitive, @Nonnull PageRequest pageRequest, @Nonnull Predicate<Integer> repositoryPredicate) {
        Query query = this.session().createQuery("SELECT c.id, c.authorTimestamp, m.repository.id FROM InternalIndexedCommit c JOIN c.attributes a WITH a.name = :name AND " + (caseSensitive ? "a.value = :value " : "lower(a.value) = lower(:value) ") + "JOIN c.repositoryMemberships m ORDER BY c.authorTimestamp DESC, c.id ASC, m.repository.id ASC", Object[].class).setParameter("name", (Object)key).setParameter("value", (Object)value);
        Page<InternalIndexedCommit> page = this.scrollCommits((Query<Object[]>)query, pageRequest, repositoryPredicate);
        if (page.getSize() == 0) {
            return page;
        }
        this.attachCommitAttributes(page);
        return page;
    }

    public InternalIndexedCommit getById(String id) {
        return (InternalIndexedCommit)HibernateUtils.initialize((Object)((InternalIndexedCommit)super.getById((Serializable)((Object)id))));
    }

    @Nonnull
    public List<InternalIndexedCommit> getByIds(@Nonnull Collection<String> ids) {
        return HibernateUtils.initializeList((List)super.getByIds(ids));
    }

    @Nonnull
    public PropertyMap getProperties(String commitId, Iterable<String> propertyKeys) {
        if (commitId == null || Iterables.isEmpty(propertyKeys)) {
            return PropertyMap.EMPTY;
        }
        List attributes = this.session().createNativeQuery("SELECT att.att_name, att.att_value FROM cs_attribute att WHERE att.cs_id = :id AND att.att_name IN (:names)").setParameter("id", (Object)commitId).setParameterList("names", HibernateIndexedCommitDao.asSet(propertyKeys)).list();
        PropertyAccumulator properties = new PropertyAccumulator();
        for (Object[] attribute : attributes) {
            properties.add((String)attribute[0], (String)attribute[1]);
        }
        return properties.toProperties();
    }

    @Nonnull
    public Map<String, PropertyMap> getProperties(Iterable<String> commitIds, Iterable<String> propertyKeys) {
        if (Iterables.isEmpty(commitIds) || Iterables.isEmpty(propertyKeys)) {
            return Collections.emptyMap();
        }
        List results = this.session().createNativeQuery("SELECT att.cs_id, att.att_name, att.att_value FROM cs_attribute att WHERE att.cs_id IN (:ids) AND att.att_name IN (:names)").setParameterList("ids", HibernateIndexedCommitDao.asSet(commitIds)).setParameterList("names", HibernateIndexedCommitDao.asSet(propertyKeys)).list();
        HashMap resultBuilder = Maps.newHashMap();
        for (Object[] row : results) {
            String commitId = (String)row[0];
            String name = (String)row[1];
            String value = (String)row[2];
            PropertyAccumulator properties = (PropertyAccumulator)resultBuilder.get(commitId);
            if (properties == null) {
                properties = new PropertyAccumulator();
                resultBuilder.put(commitId, properties);
            }
            properties.add(name, value);
        }
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)resultBuilder, PropertyAccumulator::toProperties));
    }

    @Nonnull
    public Set<String> getPropertyValues(String commitId, String key) {
        PropertyMap result = this.getProperties(commitId, Collections.singleton(key));
        return result.isEmpty() ? Collections.emptySet() : (Set)result.getAs(key, Set.class, String.class);
    }

    public boolean isIndexed(@Nonnull String commitId, @Nonnull InternalRepository repository) {
        return this.getMembership(commitId, repository) != null;
    }

    public InternalIndexedCommit loadById(String id) {
        return (InternalIndexedCommit)HibernateUtils.initialize((Object)((InternalIndexedCommit)super.loadById((Serializable)((Object)id))));
    }

    public boolean removeProperty(@Nonnull String commitId, @Nonnull String key, @Nonnull String value) {
        InternalIndexedCommit commit = this.getById(commitId);
        if (commit != null) {
            boolean result = commit.removeAttribute(new InternalCommitAttribute(key, value));
            this.session().update((Object)commit);
            return result;
        }
        return false;
    }

    @Nonnull
    public Page<InternalIndexedCommit> search(@Nonnull IndexSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        HqlQueryBuilder builder = HqlQueryBuilder.selectFrom(InternalIndexedCommit.class);
        String filter = searchRequest.getFilter();
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            if (filter.length() == 40) {
                builder.where(HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"id", (Object)filter));
            } else {
                builder.where(HqlQueryBuilder.HqlWhereQueryComponent.like((String)"id", (String)(filter + "%")));
            }
        }
        return HibernateUtils.initializePage((Page)this.pageQuery(builder.buildQuery(this.session()), pageRequest));
    }

    @Nonnull
    public Page<InternalRepositoryMembership> searchMemberships(@Nonnull String filter, @Nonnull PageRequest pageRequest, @Nonnull Predicate<InternalRepositoryMembership> predicate) {
        HqlQueryBuilder builder = HqlQueryBuilder.selectFrom(InternalRepositoryMembership.class);
        if (filter.length() == 40) {
            builder.where(HqlQueryBuilder.HqlWhereQueryComponent.equal((String)"commit.id", (Object)filter));
        } else {
            builder.where(HqlQueryBuilder.HqlWhereQueryComponent.like((String)"commit.id", (String)(filter + "%")));
        }
        return HibernateUtils.initializePage((Page)HibernatePageUtils.pageQuery((Query)builder.buildQuery(this.session()), (PageRequest)pageRequest, predicate));
    }

    public InternalIndexedCommit update(InternalIndexedCommit entity) {
        throw new UnsupportedOperationException("Indexed commits can not be updated");
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }

    private static Set<String> asSet(Iterable<String> values) {
        return values instanceof Set ? (Set)values : ImmutableSet.copyOf(values);
    }

    private void attachCommitAttributes(Page<InternalIndexedCommit> page) {
        Map commitsById = page.stream().collect(Collectors.toMap(InternalIndexedCommit::getId, Function.identity()));
        for (List commitIds : Iterables.partition(commitsById.keySet(), (int)100)) {
            List rows = this.session().createQuery("SELECT c.id, a.name, a.value FROM InternalIndexedCommit c JOIN c.attributes a WHERE c.id IN (:commitIds)", Object[].class).setParameterList("commitIds", (Collection)commitIds).list();
            for (Object[] row : rows) {
                ((InternalIndexedCommit)commitsById.get((String)row[0])).addAttribute(new InternalCommitAttribute((String)row[1], (String)row[2]));
            }
        }
    }

    private InternalRepositoryMembership getMembership(String commitId, InternalRepository repository) {
        return (InternalRepositoryMembership)this.session().get(InternalRepositoryMembership.class, (Serializable)new InternalRepositoryMembership.PK(commitId, repository.getId()));
    }

    private Page<InternalIndexedCommit> pageCommits(Query<Object[]> query, PageRequest request, Predicate<Integer> repositoryPredicate) {
        Page internalPage;
        int internalLimit = Math.min(request.getLimit() * 2, 0x100000);
        int pageLimit = request.getLimit();
        int rowIndex = request.getStart();
        PageRequest internalRequest = PageUtils.newRequest((int)rowIndex, (int)internalLimit);
        ArrayList<InternalIndexedCommit> page = new ArrayList<InternalIndexedCommit>(pageLimit);
        InternalIndexedCommit currentCommit = null;
        boolean lastPage = true;
        HashMap<Integer, InternalRepository> repositoriesById = new HashMap<Integer, InternalRepository>(pageLimit);
        block0: do {
            internalPage = this.pageQuery(query, internalRequest);
            for (Object[] row : internalPage.getValues()) {
                int repositoryId = (Integer)row[2];
                if (repositoryPredicate.test(repositoryId)) {
                    String commitId = (String)row[0];
                    Date date = (Date)row[1];
                    if (currentCommit == null || !commitId.equals(currentCommit.getId())) {
                        if (page.size() >= pageLimit) {
                            lastPage = false;
                            break block0;
                        }
                        currentCommit = new InternalIndexedCommit(commitId, date);
                        page.add(currentCommit);
                    }
                    currentCommit.addMembership(new InternalRepositoryMembership(currentCommit, repositoriesById.computeIfAbsent(repositoryId, arg_0 -> ((RepositoryDao)this.repositoryDao).getById(arg_0))));
                }
                ++rowIndex;
            }
        } while ((internalRequest = internalPage.getNextPageRequest()) != null);
        return new PageImpl(request, page, lastPage, page.size(), lastPage ? -1 : rowIndex);
    }

    private Page<InternalIndexedCommit> scrollCommits(Query<Object[]> query, PageRequest request, Predicate<Integer> repositoryPredicate) {
        int pageLimit = request.getLimit();
        int rowIndex = request.getStart();
        boolean lastPage = true;
        ArrayList<InternalIndexedCommit> page = new ArrayList<InternalIndexedCommit>(pageLimit);
        try (ScrollableResults scroll = HibernatePageUtils.createScrollableFromQuery(query, (PageRequest)request);){
            InternalIndexedCommit currentCommit = null;
            HashMap<Integer, InternalRepository> repositoriesById = new HashMap<Integer, InternalRepository>(pageLimit);
            while (scroll.next()) {
                int repositoryId = scroll.getInteger(2);
                if (repositoryPredicate.test(repositoryId)) {
                    String commitId = scroll.getString(0);
                    Date date = scroll.getDate(1);
                    if (currentCommit == null || !commitId.equals(currentCommit.getId())) {
                        if (page.size() >= pageLimit) {
                            lastPage = false;
                            break;
                        }
                        currentCommit = new InternalIndexedCommit(commitId, date);
                        page.add(currentCommit);
                    }
                    currentCommit.addMembership(new InternalRepositoryMembership(currentCommit, repositoriesById.computeIfAbsent(repositoryId, arg_0 -> ((RepositoryDao)this.repositoryDao).getById(arg_0))));
                }
                ++rowIndex;
            }
        }
        return new PageImpl(request, page, lastPage, page.size(), lastPage ? -1 : rowIndex);
    }

    private static class PropertyAccumulator {
        private final Map<String, Set<String>> properties = new HashMap<String, Set<String>>();

        private PropertyAccumulator() {
        }

        public void add(String key, String value) {
            this.properties.computeIfAbsent(key, k -> new HashSet()).add(value);
        }

        public PropertyMap toProperties() {
            return new PropertyMap.Builder().properties(this.properties).build();
        }
    }
}

