/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.dao.application.ApplicationDAOHibernate;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.stash.internal.crowd.HibernateDirectoryDao;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Hibernate;

public class HibernateApplicationDao
extends ApplicationDAOHibernate
implements ApplicationDAO {
    public List<Application> findAuthorisedApplications(long directoryId, List<String> groupNames) {
        return HibernateApplicationDao.initializeApplications(super.findAuthorisedApplications(directoryId, groupNames));
    }

    public ApplicationImpl findById(long id) throws ApplicationNotFoundException {
        return HibernateApplicationDao.initializeApplication(super.findById(id));
    }

    public ApplicationImpl findByName(String name) throws ApplicationNotFoundException {
        return HibernateApplicationDao.initializeApplication(super.findByName(name));
    }

    public ApplicationImpl load(Serializable id) throws ObjectNotFoundException {
        return HibernateApplicationDao.initializeApplication((ApplicationImpl)super.load(id));
    }

    public ApplicationImpl loadReference(long id) {
        return HibernateApplicationDao.initializeApplication((ApplicationImpl)super.loadReference(id));
    }

    public List<Application> search(EntityQuery<Application> query) {
        return HibernateApplicationDao.initializeApplications(super.search(query));
    }

    static <T extends Application> T initializeApplication(T application) {
        if (application != null) {
            Hibernate.initialize((Object)application.getAttributes());
            for (DirectoryMapping mapping : application.getDirectoryMappings()) {
                Hibernate.initialize((Object)mapping.getApplication());
                Hibernate.initialize((Object)mapping.getAllowedOperations());
                Hibernate.initialize((Object)mapping.getAuthorisedGroups());
                HibernateDirectoryDao.initializeDirectory(mapping.getDirectory());
                for (GroupMapping groupMapping : mapping.getAuthorisedGroups()) {
                    Hibernate.initialize((Object)groupMapping.getApplication());
                    Hibernate.initialize((Object)groupMapping.getDirectoryMapping());
                    Hibernate.initialize((Object)groupMapping.getDirectory());
                }
            }
            Hibernate.initialize((Object)application.getRemoteAddresses());
            Hibernate.initialize((Object)application.getWebhooks());
        }
        return application;
    }

    static List<Application> initializeApplications(List<Application> applications) {
        for (Application application : applications) {
            HibernateApplicationDao.initializeApplication(application);
        }
        return applications;
    }
}

