/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.directory.TransactionalDirectoryDao;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Hibernate;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class HibernateDirectoryDao
extends DirectoryDAOHibernate
implements TransactionalDirectoryDao {
    @Transactional(readOnly=true)
    public List<Directory> findAll() {
        return HibernateDirectoryDao.initializeDirectories(super.findAll());
    }

    @Transactional(readOnly=true)
    public DirectoryImpl findById(long id) throws DirectoryNotFoundException {
        return HibernateDirectoryDao.initializeDirectory(super.findById(id));
    }

    @Transactional(readOnly=true)
    public DirectoryImpl findByName(String name) throws DirectoryNotFoundException {
        return HibernateDirectoryDao.initializeDirectory(super.findByName(name));
    }

    @Transactional(readOnly=true)
    public DirectoryImpl load(Serializable id) throws ObjectNotFoundException {
        return HibernateDirectoryDao.initializeDirectory((DirectoryImpl)super.load(id));
    }

    @Transactional(readOnly=true)
    public DirectoryImpl loadReference(long id) {
        return HibernateDirectoryDao.initializeDirectory((DirectoryImpl)super.loadReference(id));
    }

    @Transactional(readOnly=true)
    public List<Directory> search(EntityQuery query) {
        return HibernateDirectoryDao.initializeDirectories(super.search(query));
    }

    static <T extends Directory> T initializeDirectory(T directory) {
        if (directory != null) {
            Hibernate.initialize((Object)directory.getAllowedOperations());
            Hibernate.initialize((Object)directory.getAttributes());
        }
        return directory;
    }

    static List<Directory> initializeDirectories(List<Directory> directories) {
        for (Directory directory : directories) {
            HibernateDirectoryDao.initializeDirectory(directory);
        }
        return directories;
    }
}

