/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.dao.group.GroupDAOHibernate;
import com.atlassian.crowd.dao.group.InternalGroupDao;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.group.InternalGroupAttribute;
import com.atlassian.crowd.model.group.InternalGroupWithAttributes;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.stash.internal.crowd.HibernateDirectoryDao;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;

public class HibernateGroupDao
extends GroupDAOHibernate
implements GroupDao,
InternalGroupDao {
    public InternalGroup findByName(long directoryId, String groupName) throws GroupNotFoundException {
        return HibernateGroupDao.initializeGroup(super.findByName(directoryId, groupName));
    }

    public Collection<InternalGroup> findByNames(long directoryId, Collection<String> groupnames) {
        return this.detachGroups(super.findByNames(directoryId, groupnames));
    }

    public InternalGroupWithAttributes findByNameWithAttributes(long directoryId, String groupName) throws GroupNotFoundException {
        InternalGroupWithAttributes result = super.findByNameWithAttributes(directoryId, groupName);
        HibernateGroupDao.initializeGroup(result.getInternalGroup());
        return result;
    }

    public Set<InternalGroupAttribute> findGroupAttributes(long groupId) {
        Set result = super.findGroupAttributes(groupId);
        for (InternalGroupAttribute attribute : result) {
            HibernateDirectoryDao.initializeDirectory(attribute.getDirectory());
            HibernateGroupDao.initializeGroup(attribute.getGroup());
        }
        return result;
    }

    public <T> List<T> search(long directoryId, EntityQuery<T> query) {
        List result = super.search(directoryId, query);
        for (Object item : result) {
            if (item instanceof InternalGroup) {
                HibernateGroupDao.initializeGroup((InternalGroup)item);
                continue;
            }
            if (!(item instanceof InternalGroupWithAttributes)) continue;
            HibernateGroupDao.initializeGroup(((InternalGroupWithAttributes)item).getInternalGroup());
        }
        return result;
    }

    public InternalGroup load(Serializable id) throws ObjectNotFoundException {
        return HibernateGroupDao.initializeGroup((InternalGroup)super.load(id));
    }

    public InternalGroup loadReference(long id) {
        return HibernateGroupDao.initializeGroup((InternalGroup)super.loadReference(id));
    }

    static InternalGroup initializeGroup(InternalGroup group) {
        if (group != null) {
            HibernateDirectoryDao.initializeDirectory(group.getDirectory());
        }
        return group;
    }

    Collection<InternalGroup> detachGroups(Collection<InternalGroup> groups) {
        if (groups != null) {
            Session session = this.session();
            for (InternalGroup group : groups) {
                HibernateGroupDao.initializeGroup(group);
                session.evict((Object)group);
            }
        }
        return groups;
    }
}

