/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.dao.membership.InternalMembershipDao;
import com.atlassian.crowd.dao.membership.MembershipDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisationFinishedEvent;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.membership.InternalMembership;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.crowd.HibernateDirectoryDao;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class HibernateMembershipDao
extends MembershipDAOHibernate
implements MembershipDao,
InternalMembershipDao {
    @Value(value="${hibernate.jdbc.large_fetch_size:1000}")
    private int fetchSize;
    private HQLQueryTranslater hqlQueryTranslater;

    public <T> List<T> search(long directoryId, MembershipQuery<T> query) {
        HQLQuery hqlQuery = this.hqlQueryTranslater.asHQL(directoryId, query);
        hqlQuery.setCacheRegion("query.groupMemberships");
        hqlQuery.setFetchSize(Integer.valueOf(this.fetchSize));
        List results = this.executeHQLQuery(hqlQuery);
        for (Object item : results) {
            if (!(item instanceof InternalMembership)) continue;
            HibernateMembershipDao.initializeMembership((InternalMembership)item);
        }
        return results;
    }

    public List<InternalMembership> findAll(Collection<Directory> directories) {
        return HibernateMembershipDao.initializeMemberships(super.findAll(directories));
    }

    public List<InternalMembership> findAllLocal(Collection<Directory> directories) {
        return HibernateMembershipDao.initializeMemberships(super.findAllLocal(directories));
    }

    public InternalMembership load(Serializable id) throws ObjectNotFoundException {
        return HibernateMembershipDao.initializeMembership((InternalMembership)super.load(id));
    }

    public InternalMembership loadReference(long id) {
        return HibernateMembershipDao.initializeMembership((InternalMembership)super.loadReference(id));
    }

    @EventListener
    public void onDirectorySynchronised(RemoteDirectorySynchronisationFinishedEvent unused) {
        this.sessionFactory.getCache().evictQueryRegion("query.groupMemberships");
    }

    @Autowired
    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        super.setHqlQueryTranslater(hqlQueryTranslater);
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    static InternalMembership initializeMembership(InternalMembership membership) {
        if (membership != null) {
            HibernateDirectoryDao.initializeDirectory(membership.getDirectory());
        }
        return membership;
    }

    static List<InternalMembership> initializeMemberships(List<InternalMembership> memberships) {
        for (InternalMembership membership : memberships) {
            HibernateMembershipDao.initializeMembership(membership);
        }
        return memberships;
    }
}

