/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.bitbucket.event.project.ProjectModifiedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.crowd.dao.user.InternalUserDao;
import com.atlassian.crowd.dao.user.UserDAOHibernate;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisationFinishedEvent;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.InternalEntity;
import com.atlassian.crowd.model.InternalEntityAttribute;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.InternalUserAttribute;
import com.atlassian.crowd.model.user.InternalUserCredentialRecord;
import com.atlassian.crowd.model.user.InternalUserWithAttributes;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.batch.HibernateOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate5.operation.RemoveUserOperation;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.crowd.HibernateDirectoryDao;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.project.ProjectDao;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.AbstractVoidInternalStashUserVisitor;
import com.atlassian.stash.internal.user.ApplicationUserDao;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.DiffBuilder;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.Session;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class HibernateUserDao
extends UserDAOHibernate
implements UserDao,
InternalUserDao {
    private final ApplicationFactory applicationFactory;
    private final ApplicationUserDao appUserDao;
    private final EventPublisher eventPublisher;
    private final Set<String> ignoredUserAttributes;
    private final ProjectDao projectDao;
    private final TransactionTemplate readOnlyTxTemplate;
    private final SecurityService securityService;
    private int batchSize;
    private int maxEntityCount;

    @Autowired
    public HibernateUserDao(@Lazy ApplicationFactory applicationFactory, EventPublisher eventPublisher, ProjectDao projectDao, ApplicationUserDao appUserDao, @Lazy SecurityService securityService, PlatformTransactionManager transactionManager, @Value(value="${crowd.ignored.user.attributes}") String ignoredUserAttributes) {
        this.applicationFactory = applicationFactory;
        this.eventPublisher = eventPublisher;
        this.projectDao = projectDao;
        this.appUserDao = appUserDao;
        this.securityService = securityService;
        this.ignoredUserAttributes = (Set)MoreStreams.streamIterable((Iterable)Splitter.on((String)",").split((CharSequence)ignoredUserAttributes)).map(StringUtils::trimToNull).filter(Objects::nonNull).collect(MoreCollectors.toImmutableSet());
        this.readOnlyTxTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.readOnlyTxTemplate.setReadOnly(true);
    }

    public InternalUser add(com.atlassian.crowd.model.user.User user, PasswordCredential passwordCredential) throws UserAlreadyExistsException, IllegalArgumentException, DirectoryNotFoundException {
        this.appUserDao.createFor((User)user);
        return super.add(user, passwordCredential);
    }

    public BatchResult<com.atlassian.crowd.model.user.User> addAll(Set<UserTemplateWithCredentialAndAttributes> userTemplateWithCredentialAndAttributes) {
        BatchResult result = super.addAll(userTemplateWithCredentialAndAttributes);
        int count = 0;
        for (com.atlassian.crowd.model.user.User createdUser : result.getSuccessfulEntities()) {
            this.appUserDao.createFor((User)createdUser);
            if (++count < this.batchSize) continue;
            count = 0;
            this.session().flush();
            this.session().clear();
        }
        return result;
    }

    public InternalUser findByName(long directoryId, String username) throws UserNotFoundException {
        return this.internalFindByName(directoryId, username);
    }

    public InternalUserWithAttributes findByNameWithAttributes(long directoryId, String username) throws UserNotFoundException {
        InternalUser user = this.internalFindByName(directoryId, username);
        return new InternalUserWithAttributes(user);
    }

    public Collection<InternalUser> findByNames(long directoryId, Collection<String> usernames) {
        return this.detachUsers(super.findByNames(directoryId, usernames));
    }

    public Set<InternalUserAttribute> findUserAttributes(long userId) {
        List attributes = this.session().createQuery("select attributes from InternalUser where id = :id").setParameter("id", (Object)userId, (Type)StandardBasicTypes.LONG).list();
        return attributes.stream().map(HibernateUserDao::initializeAttribute).collect(Collectors.toSet());
    }

    protected DiffResult storeAttributes(InternalUser userWithAttributes, Map<String, Set<String>> attributesToSet) {
        Set attributes = userWithAttributes.getAttributes();
        DiffBuilder diffBuilder = new DiffBuilder((Object)userWithAttributes.getName(), (Object)userWithAttributes.getName(), ToStringStyle.SIMPLE_STYLE, false);
        Map<String, Set> existingAttributesMap = attributes.stream().collect(Collectors.toMap(InternalEntityAttribute::getName, value -> {
            HashSet<InternalUserAttribute> existingValues = new HashSet<InternalUserAttribute>();
            existingValues.add((InternalUserAttribute)value);
            return existingValues;
        }, (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        }));
        for (Map.Entry<String, Set<String>> entry : attributesToSet.entrySet()) {
            Set existingAttributes = (Set)MoreObjects.firstNonNull((Object)existingAttributesMap.get(entry.getKey()), Collections.emptySet());
            if (this.ignoredUserAttributes.contains(entry.getKey())) {
                attributes.removeAll(existingAttributes);
                existingAttributes.forEach(arg_0 -> ((HibernateUserDao)this).remove(arg_0));
                continue;
            }
            Set currentValues = existingAttributes.stream().map(InternalEntityAttribute::getValue).collect(Collectors.toSet());
            Set<String> desiredValues = entry.getValue();
            diffBuilder.append(entry.getKey(), currentValues, desiredValues);
            Set valsToRemove = existingAttributes.stream().filter(attr -> !desiredValues.contains(attr.getValue())).collect(Collectors.toSet());
            ArrayList<String> valsToAdd = new ArrayList<String>((Collection<String>)Sets.difference(desiredValues, currentValues));
            for (InternalUserAttribute existingAttribute : valsToRemove) {
                if (valsToAdd.size() > 0) {
                    String newVal = (String)valsToAdd.remove(0);
                    existingAttribute.setValue(newVal);
                    this.saveOrUpdate(existingAttribute);
                    continue;
                }
                attributes.remove(existingAttribute);
                this.remove(existingAttribute);
            }
            valsToAdd.forEach(val -> this.addAttribute(userWithAttributes, (String)entry.getKey(), (String)val));
        }
        return diffBuilder.build();
    }

    public InternalUser load(Serializable id) throws ObjectNotFoundException {
        return HibernateUserDao.initializeUser((InternalUser)super.load(id));
    }

    public InternalUser loadReference(long id) {
        return HibernateUserDao.initializeUser((InternalUser)super.loadReference(id));
    }

    @EventListener
    public void onDirectorySynchronised(RemoteDirectorySynchronisationFinishedEvent unused) {
        this.sessionFactory.getCache().evictQueryRegion("query.cwdUserByDirectory");
    }

    public BatchResult<String> removeAllUsers(long directoryId, Set<String> userNames) {
        Collection users = (Collection)this.readOnlyTxTemplate.execute(status -> this.findByNames(directoryId, userNames));
        BatchResult batchResult = this.batchProcessor.execute((HibernateOperation)new RemoveUserOperation(), users);
        BatchResult overallResult = new BatchResult(userNames.size());
        overallResult.addFailures(batchResult.getFailedEntities().stream().map(InternalEntity::getName).toList());
        overallResult.addSuccesses(batchResult.getSuccessfulEntities().stream().map(InternalEntity::getName).toList());
        return overallResult;
    }

    public InternalUser rename(com.atlassian.crowd.model.user.User user, String newUsername) throws UserNotFoundException, UserAlreadyExistsException {
        String oldUsername = user.getName();
        boolean shouldRenameStashUser = this.archiveIfNeeded(user.getDirectoryId(), oldUsername, newUsername);
        InternalUser renamedUser = super.rename(user, newUsername);
        if (shouldRenameStashUser) {
            InternalNormalUser renamedStashUser = this.appUserDao.rename(oldUsername, newUsername);
            if (renamedStashUser == null) {
                this.logger.info("User {} not found during rename to {}. Creating a new user instead.", (Object)user.getName(), (Object)newUsername);
                this.appUserDao.createFor((User)renamedUser);
            } else {
                renamedStashUser.accept((InternalStashUserVisitor)new AbstractVoidInternalStashUserVisitor(){

                    protected void doVisit(@Nonnull InternalNormalUser renamedStashUser) {
                        HibernateUserDao.this.renamePersonalProject(renamedStashUser);
                    }
                });
            }
        }
        if (this.session().getStatistics().getEntityCount() > this.maxEntityCount) {
            this.session().flush();
            this.session().clear();
        }
        return renamedUser;
    }

    public <T> List<T> search(long directoryID, EntityQuery<T> query) {
        List result = super.search(directoryID, query);
        for (Object item : result) {
            if (item instanceof InternalUser) {
                HibernateUserDao.initializeUser((InternalUser)item);
            }
            if (!(item instanceof InternalUserCredentialRecord)) continue;
            HibernateUserDao.initializeUser(((InternalUserCredentialRecord)item).getUser());
        }
        return result;
    }

    public void storeAttributes(com.atlassian.crowd.model.user.User user, Map<String, Set<String>> attributes, boolean updateTimestamp) throws UserNotFoundException {
        InternalUser internalUser = this.asInternalUser(user);
        if (!this.session().contains((Object)internalUser)) {
            try {
                internalUser = this.load(internalUser.getId());
            }
            catch (ObjectNotFoundException e) {
                throw new UserNotFoundException(user.getName(), (Throwable)e);
            }
        }
        if (updateTimestamp) {
            this.updateTimestamps((InternalEntity)internalUser, false);
        }
        this.storeAttributes(internalUser, attributes);
    }

    @Value(value="${hibernate.jdbc.batch_size}")
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Value(value="${crowd.user.rename.max_entity_count}")
    public void setMaxEntityCount(int maxEntityCount) {
        this.maxEntityCount = maxEntityCount;
    }

    @VisibleForTesting
    boolean archiveIfNeeded(long directoryId, String oldUsername, String newUsername) throws UserAlreadyExistsException {
        InternalNormalUser existingUser;
        if (!IdentifierUtils.equalsInLowerCase((String)oldUsername, (String)newUsername) && (existingUser = this.appUserDao.findByName(newUsername)) != null) {
            User backingCrowdUser = (User)existingUser.accept(InternalApplicationUser.TO_CROWD_USER);
            if (backingCrowdUser != null) {
                this.logger.debug("Existing stash user is backed by a crowd user with name [{}] in directory [{}]", (Object)backingCrowdUser.getName(), (Object)backingCrowdUser.getDirectoryId());
                if (backingCrowdUser.getDirectoryId() == directoryId) {
                    throw new UserAlreadyExistsException(backingCrowdUser.getDirectoryId(), existingUser.getName());
                }
                if (this.isDirectoryLowerPrecedence(directoryId, backingCrowdUser.getDirectoryId())) {
                    this.logger.debug("Crowd user with name [{}] in directory [{}] is going to be shadowed. The associated stash users will remain untouched", (Object)backingCrowdUser.getName(), (Object)backingCrowdUser.getDirectoryId());
                    return false;
                }
            }
            existingUser = this.appUserDao.archive(existingUser);
            this.renamePersonalProject(existingUser);
        }
        return true;
    }

    @VisibleForTesting
    void renamePersonalProject(InternalNormalUser user) {
        InternalPersonalProject project = this.projectDao.getByOwner(user.getId());
        if (project != null) {
            InternalPersonalProject current = project.copy().build();
            InternalPersonalProject updated = current.copy().owner(user).build();
            if (!current.getKey().equals(updated.getKey())) {
                this.securityService.impersonating((ApplicationUser)user, "Renaming personal project").call(() -> this.lambda$renamePersonalProject$5(current, (InternalProject)updated));
            }
        }
    }

    private static InternalUserAttribute initializeAttribute(InternalUserAttribute attribute) {
        if (attribute != null) {
            HibernateDirectoryDao.initializeDirectory(attribute.getDirectory());
            HibernateUserDao.initializeUser(attribute.getUser());
        }
        return attribute;
    }

    private static InternalUser initializeUser(InternalUser user) {
        if (user != null) {
            HibernateDirectoryDao.initializeDirectory(user.getDirectory());
        }
        return user;
    }

    private InternalUser asInternalUser(com.atlassian.crowd.model.user.User user) throws UserNotFoundException {
        if (user instanceof InternalUser) {
            return (InternalUser)user;
        }
        if (user instanceof InternalUserWithAttributes) {
            return ((InternalUserWithAttributes)user).getInternalUser();
        }
        return this.findByName(user.getDirectoryId(), user.getName());
    }

    private Collection<InternalUser> detachUsers(Collection<InternalUser> users) {
        if (users != null) {
            Session session = this.session();
            for (InternalUser user : users) {
                HibernateUserDao.initializeUser(user);
                session.evict((Object)user);
            }
        }
        return users;
    }

    private InternalUser internalFindByName(long directoryId, String username) throws UserNotFoundException {
        InternalUser user = (InternalUser)this.session().createQuery("from InternalUser where directory.id = :directoryId and lowerName = :lowerName", InternalUser.class).setParameter("directoryId", (Object)directoryId).setParameter("lowerName", (Object)IdentifierUtils.toLowerCase((String)username)).setCacheable(true).setCacheRegion("query.cwdUserByDirectory").uniqueResult();
        if (user == null) {
            throw new UserNotFoundException(username);
        }
        return HibernateUserDao.initializeUser(user);
    }

    private boolean isDirectoryLowerPrecedence(long firstDirectoryId, long secondDirectoryId) {
        Application application = this.applicationFactory.getApplication();
        for (DirectoryMapping mapping : application.getDirectoryMappings()) {
            if (firstDirectoryId == mapping.getDirectory().getId()) {
                return false;
            }
            if (secondDirectoryId != mapping.getDirectory().getId()) continue;
            return true;
        }
        throw new IllegalStateException(String.format("Neither directory %d or %d exist", firstDirectoryId, secondDirectoryId));
    }

    private /* synthetic */ Object lambda$renamePersonalProject$5(InternalPersonalProject current, InternalProject updated) throws RuntimeException {
        this.eventPublisher.publish((Object)new ProjectModifiedEvent((Object)this, (Project)current, (Project)this.projectDao.update((Object)updated)));
        return null;
    }
}

