/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.darkfeature;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.darkfeature.InternalUserDarkFeature;
import com.atlassian.stash.internal.darkfeature.UserDarkFeatureDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="userDarkFeatureDao")
public class HibernateUserDarkFeatureDao
extends AbstractHibernateDao<Integer, InternalUserDarkFeature>
implements UserDarkFeatureDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.emptyList();

    @Autowired
    public HibernateUserDarkFeatureDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public boolean existsByFeatureAndEnabled(@Nonnull String featureKey, boolean enabled) {
        Objects.requireNonNull(featureKey, "featureKey");
        return this.session().createQuery("SELECT 1 FROM InternalUserDarkFeature WHERE featureKey = :featureKey AND enabled = :enabled").setParameter("featureKey", (Object)featureKey).setParameter("enabled", (Object)enabled).setMaxResults(1).uniqueResultOptional().isPresent();
    }

    @Nullable
    public InternalUserDarkFeature getByUserAndFeature(int userId, @Nonnull String featureKey) {
        Objects.requireNonNull(featureKey, "featureKey");
        Query query = this.session().createQuery("FROM InternalUserDarkFeature WHERE user.id = :userId AND featureKey = :featureKey", InternalUserDarkFeature.class).setParameter("userId", (Object)userId).setParameter("featureKey", (Object)featureKey);
        return (InternalUserDarkFeature)query.uniqueResult();
    }

    @Nonnull
    public Set<InternalUserDarkFeature> getByUserId(int userId) {
        List darkFeatures = this.session().createQuery("FROM InternalUserDarkFeature WHERE user.id = :userId", InternalUserDarkFeature.class).setParameter("userId", (Object)userId).list();
        return ImmutableSet.copyOf((Collection)darkFeatures);
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

