/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.atlassian.stash.internal.db.AbstractDatabaseSupportLevel;
import com.atlassian.stash.internal.db.AzureSqlServerSupportLevel;
import com.atlassian.stash.internal.db.Database;
import com.atlassian.stash.internal.db.DatabaseAffixed;
import com.atlassian.stash.internal.db.DatabaseFactory;
import com.atlassian.stash.internal.db.DatabaseSupplier;
import com.atlassian.stash.internal.db.DatabaseSupportLevel;
import com.atlassian.stash.internal.db.DelegatingDetailedDatabase;
import com.atlassian.stash.internal.db.DetailedDatabase;
import com.atlassian.stash.internal.db.OracleSupportLevel;
import com.atlassian.stash.internal.db.PostgreSqlSupportLevel;
import com.atlassian.stash.internal.db.SqlServerSupportLevel;
import com.atlassian.stash.internal.db.UnsupportedDatabaseException;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import io.atlassian.util.concurrent.LazyReference;
import io.atlassian.util.concurrent.ResettableLazyReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.sql.Connection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="databaseSupplier")
public class DefaultDatabaseSupplier
implements DatabaseAffixed,
DatabaseSupplier {
    private static final Map<String, Function<Database, DetailedDatabase>> NAMES_TO_DETAILERS = ImmutableMap.builder().put((Object)"Microsoft Azure SQL Database", (Object)new AzureSqlServerSupportLevel()).put((Object)"H2", (Object)new InternalSupportLevel(DatabaseSupportLevel.SUPPORTED)).put((Object)"HSQL", (Object)new InternalSupportLevel(DatabaseSupportLevel.DEPRECATED)).put((Object)"Oracle", (Object)new OracleSupportLevel()).put((Object)"PostgreSQL", (Object)new PostgreSqlSupportLevel()).put((Object)"Microsoft SQL Server", (Object)new SqlServerSupportLevel()).build();
    private static final Logger log = LoggerFactory.getLogger(DefaultDatabaseSupplier.class);
    private final DatabaseFactory databaseFactory;
    private final ResettableLazyReference<DetailedDatabase> databaseReference;
    private boolean ignoreUnsupported;

    @Autowired
    public DefaultDatabaseSupplier(final DatabaseFactory databaseFactory, final DataSource dataSource) {
        this.databaseFactory = databaseFactory;
        this.databaseReference = new ResettableLazyReference<DetailedDatabase>(this){

            protected DetailedDatabase create() {
                return DefaultDatabaseSupplier.detailsFor(databaseFactory.create(dataSource));
            }
        };
    }

    @Nonnull
    public DetailedDatabase get() {
        try {
            return (DetailedDatabase)this.databaseReference.get();
        }
        catch (LazyReference.InitializationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ExecutionException) {
                cause = cause.getCause();
            }
            Throwables.propagateIfPossible((Throwable)cause);
            throw e;
        }
    }

    @Nonnull
    public DetailedDatabase getForConnection(@Nonnull Connection connection) {
        return DefaultDatabaseSupplier.detailsFor(this.databaseFactory.create(Objects.requireNonNull(connection, "connection")));
    }

    public void release() {
        this.databaseReference.reset();
    }

    @Value(value="${jdbc.ignoreunsupported}")
    public void setIgnoreUnsupported(boolean ignoreUnsupported) {
        this.ignoreUnsupported = ignoreUnsupported;
    }

    @PostConstruct
    public void validate() {
        if (this.ignoreUnsupported) {
            log.warn("Not checking database support level; the check has been disabled");
            return;
        }
        DetailedDatabase database = this.get();
        if (DatabaseSupportLevel.UNSUPPORTED == database.getSupportLevel()) {
            throw new UnsupportedDatabaseException("The configured database is unsupported", (Database)database);
        }
    }

    @Nonnull
    private static DetailedDatabase detailsFor(Database database) {
        Function<Database, DetailedDatabase> detailer = NAMES_TO_DETAILERS.get(database.getName());
        if (detailer == null) {
            log.error("{} is not a supported database", (Object)database.getName());
            return new DelegatingDetailedDatabase(database, DatabaseSupportLevel.UNSUPPORTED, null);
        }
        return detailer.apply(database);
    }

    private static class InternalSupportLevel
    extends AbstractDatabaseSupportLevel {
        private final DatabaseSupportLevel supportLevel;

        InternalSupportLevel(DatabaseSupportLevel supportLevel) {
            super(null);
            this.supportLevel = supportLevel;
        }

        @Override
        @Nonnull
        protected DatabaseSupportLevel supportFor(@Nonnull Database database) {
            return this.supportLevel;
        }
    }
}

