/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.atlassian.bitbucket.util.Version;
import com.atlassian.stash.internal.db.Database;
import com.atlassian.stash.internal.db.DatabaseSupportLevel;
import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.db.DetailedDatabase;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class DelegatingDetailedDatabase
implements DetailedDatabase {
    private final Database database;
    private final DatabaseSupportLevel supportLevel;
    private final DbType type;

    public DelegatingDetailedDatabase(Database database, DatabaseSupportLevel supportLevel, DbType type) {
        this.database = Objects.requireNonNull(database, "database");
        this.supportLevel = Objects.requireNonNull(supportLevel, "supportLevel");
        this.type = type;
    }

    public int getMajorVersion() {
        return this.database.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.database.getMinorVersion();
    }

    @Nonnull
    public String getName() {
        return this.database.getName();
    }

    public int getPatchVersion() {
        return this.database.getPatchVersion();
    }

    @Nonnull
    public DatabaseSupportLevel getSupportLevel() {
        return this.supportLevel;
    }

    public DbType getType() {
        return this.type;
    }

    @Nonnull
    public Version getVersion() {
        return this.database.getVersion();
    }

    public boolean isAurora() {
        return this.database.isAurora();
    }

    public boolean isInternal() {
        return "H2".equals(this.getName()) || "HSQL".equals(this.getName());
    }
}

