/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.atlassian.bitbucket.util.Version;
import com.atlassian.stash.internal.db.Database;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class JdbcMetadataDatabase
implements Database {
    private final boolean aurora;
    private final int majorVersion;
    private final int minorVersion;
    private final String name;
    private final int patchVersion;
    private final Version version;

    public JdbcMetadataDatabase(boolean aurora, @Nonnull String name, @Nonnull Version version) {
        this.aurora = aurora;
        this.name = Objects.requireNonNull(name, "name");
        this.version = Objects.requireNonNull(version, "version");
        this.majorVersion = version.getMajor();
        this.minorVersion = version.getMinor();
        this.patchVersion = version.getPatch();
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public int getPatchVersion() {
        return this.patchVersion;
    }

    @Nonnull
    public Version getVersion() {
        return this.version;
    }

    public boolean isAurora() {
        return this.aurora;
    }
}

