/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.atlassian.bitbucket.util.Version;
import com.atlassian.stash.internal.db.Database;
import com.atlassian.stash.internal.db.DatabaseFactory;
import com.atlassian.stash.internal.db.JdbcMetadataDatabase;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class MetadataDatabaseFactory
implements DatabaseFactory {
    @VisibleForTesting
    static final String MSSQL_EDITION_AZURE = "SQL Azure";
    @VisibleForTesting
    static final int MSSQL_EDITION_COLUMN = 1;
    static final Pattern PATTERN_ORACLE_VERSION = Pattern.compile(".+\\s([\\d.]+)\\s.*", 32);
    private static final String PRODUCT_HSQL = "HSQL Database Engine";
    private static final Logger log = LoggerFactory.getLogger(MetadataDatabaseFactory.class);

    @Override
    @Nonnull
    public Database create(@Nonnull Connection connection) {
        Objects.requireNonNull(connection, "connection");
        try {
            return MetadataDatabaseFactory.databaseFor(connection);
        }
        catch (SQLException e) {
            throw new DataRetrievalFailureException("Could not load database metadata", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Database create(@Nonnull DataSource dataSource) {
        Connection connection = null;
        try {
            connection = DataSourceUtils.getConnection((DataSource)dataSource);
            Database database = this.create(connection);
            return database;
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
        }
    }

    private static Database databaseFor(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        String productName = metaData.getDatabaseProductName();
        String productVersion = metaData.getDatabaseProductVersion();
        Version version = null;
        if ("Oracle".equals(productName)) {
            Matcher matcher = PATTERN_ORACLE_VERSION.matcher(productVersion);
            if (matcher.matches()) {
                version = new Version(matcher.group(1));
            } else {
                log.warn("Could not parse Oracle version [{}]; using major and minor versions", (Object)productVersion);
                version = new Version(new Integer[]{metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion()});
            }
        }
        if (PRODUCT_HSQL.equals(productName)) {
            productName = "HSQL";
        } else if (MetadataDatabaseFactory.isMSQLAzure(productName, connection)) {
            productName = "Microsoft Azure SQL Database";
        }
        return new JdbcMetadataDatabase(MetadataDatabaseFactory.isAurora(productName, connection), PRODUCT_HSQL.equals(productName) ? "HSQL" : productName, version == null ? new Version(productVersion) : version);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean isAurora(String productName, Connection connection) {
        if (productName.equals("PostgreSQL")) {
            try (Statement statement = connection.createStatement();){
                boolean bl;
                block15: {
                    ResultSet resultSet = statement.executeQuery("select aurora_version()");
                    try {
                        bl = resultSet.next();
                        if (resultSet == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    resultSet.close();
                }
                return bl;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isMSQLAzure(String productName, Connection connection) throws SQLException {
        block17: {
            if (productName.equals("Microsoft SQL Server")) {
                try (Statement statement = connection.createStatement();
                     ResultSet resultSet = statement.executeQuery("SELECT SERVERPROPERTY('Edition')");){
                    if (resultSet.next()) {
                        if (MSSQL_EDITION_AZURE.equals(resultSet.getString(1))) {
                            boolean bl = true;
                            return bl;
                        }
                        break block17;
                    }
                    throw new DataRetrievalFailureException("Unable to retrieve Microsoft SQL server edition from the database. Verify database connectivity and try again.");
                }
            }
        }
        return false;
    }
}

