/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.atlassian.stash.internal.db.AbstractDatabaseSupportLevel;
import com.atlassian.stash.internal.db.Database;
import com.atlassian.stash.internal.db.DatabaseSupportLevel;
import com.atlassian.stash.internal.db.DbType;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Set;

class OracleSupportLevel
extends AbstractDatabaseSupportLevel {
    private static final Set<Integer> SUPPORTED_VERSIONS = ImmutableSet.of((Object)19, (Object)23);

    OracleSupportLevel() {
        super(DbType.ORACLE);
    }

    @Override
    @Nonnull
    protected DatabaseSupportLevel supportFor(@Nonnull Database database) {
        int major = database.getMajorVersion();
        if (SUPPORTED_VERSIONS.contains(major)) {
            return DatabaseSupportLevel.SUPPORTED;
        }
        if (major > Collections.min(SUPPORTED_VERSIONS)) {
            return DatabaseSupportLevel.UNKNOWN;
        }
        return DatabaseSupportLevel.UNSUPPORTED;
    }
}

