/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.atlassian.stash.internal.db.AbstractDatabaseSupportLevel;
import com.atlassian.stash.internal.db.Database;
import com.atlassian.stash.internal.db.DatabaseSupportLevel;
import com.atlassian.stash.internal.db.DbType;
import jakarta.annotation.Nonnull;

class SqlServerSupportLevel
extends AbstractDatabaseSupportLevel {
    private static final int SQL_SERVER_2019 = 15;
    private static final int SQL_SERVER_2022 = 16;

    SqlServerSupportLevel() {
        super(DbType.MSSQL);
    }

    @Override
    @Nonnull
    public DatabaseSupportLevel supportFor(@Nonnull Database database) {
        int major = database.getMajorVersion();
        if (major < 15) {
            return DatabaseSupportLevel.UNSUPPORTED;
        }
        if (major > 16) {
            return DatabaseSupportLevel.UNKNOWN;
        }
        return DatabaseSupportLevel.SUPPORTED;
    }
}

