/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.diagnostics;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.diagnostics.Alert;
import com.atlassian.diagnostics.AlertCriteria;
import com.atlassian.diagnostics.CallbackResult;
import com.atlassian.diagnostics.PageRequest;
import com.atlassian.diagnostics.Severity;
import com.atlassian.diagnostics.internal.dao.AlertEntity;
import com.atlassian.diagnostics.internal.dao.AlertEntityDao;
import com.atlassian.diagnostics.internal.dao.AlertMetric;
import com.atlassian.diagnostics.internal.dao.MinimalAlertEntity;
import com.atlassian.diagnostics.internal.dao.RowCallback;
import com.atlassian.diagnostics.internal.dao.SimpleMinimalAlertEntity;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.diagnostics.InternalAlert;
import com.atlassian.stash.internal.diagnostics.InternalAlert_;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="alertDao")
public class HibernateAlertDao
extends AbstractHibernateDao<Long, InternalAlert>
implements AlertEntityDao {
    private static final String COLUMN_TIMESTAMP = "timestamp";
    private static final Iterable<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singleton(HqlQueryBuilder.HqlQueryOrder.desc((String)"timestamp"));

    @Autowired
    public HibernateAlertDao(@Nonnull SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public void deleteAll(@Nonnull AlertCriteria alertCriteria) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaDelete criteriaDelete = builder.createCriteriaDelete(InternalAlert.class);
        Root root = criteriaDelete.from(InternalAlert.class);
        List<Predicate> predicates = this.getCriteriaPredicates(builder, (Root<InternalAlert>)root, alertCriteria);
        criteriaDelete.where(predicates.toArray(new Predicate[0]));
        this.session().createQuery(criteriaDelete).executeUpdate();
    }

    public Set<String> findAllComponentIds() {
        return new HashSet<String>(this.session().createQuery("SELECT DISTINCT issueComponentId from InternalAlert", String.class).list());
    }

    public Map<String, Severity> findAllIssueIds() {
        Query query = this.session().createQuery("SELECT DISTINCT issueId, issueSeverity from InternalAlert", Object[].class);
        return query.stream().collect(Collectors.toMap(HibernateAlertDao.itemAt(0, String.class), HibernateAlertDao.itemAt(1, Severity.class)));
    }

    public Set<String> findAllNodeNames() {
        return new HashSet<String>(this.session().createQuery("SELECT DISTINCT nodeName from InternalAlert", String.class).list());
    }

    public Set<String> findAllPluginKeys() {
        return new HashSet<String>(this.session().createQuery("SELECT DISTINCT triggerPluginKey from InternalAlert", String.class).list());
    }

    public AlertEntity getById(long id) {
        return (AlertEntity)this.session().get(InternalAlert.class, (Serializable)Long.valueOf(id));
    }

    public void streamAll(@Nonnull AlertCriteria alertCriteria, @Nonnull RowCallback<AlertEntity> rowCallback, @Nonnull PageRequest pageRequest) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(InternalAlert.class);
        Root root = criteriaQuery.from(InternalAlert.class);
        Path id = root.get(InternalAlert_.id);
        Path timestamp = root.get(InternalAlert_.timestamp);
        List<Predicate> predicates = this.getCriteriaPredicates(builder, (Root<InternalAlert>)root, alertCriteria);
        Query query = this.session().createQuery(criteriaQuery.select((Selection)root).where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{builder.desc((Expression)timestamp), builder.desc((Expression)id)})).setFirstResult(pageRequest.getStart()).setMaxResults(pageRequest.getLimit() + 1);
        this.scrollQuery(query, value -> {
            InternalAlert alert = (InternalAlert)value.get(0);
            try {
                boolean bl = rowCallback.onRow((Object)alert) == CallbackResult.DONE;
                return bl;
            }
            finally {
                this.session().evict((Object)alert);
            }
        });
    }

    public void streamMetrics(@Nonnull AlertCriteria criteria, @Nonnull RowCallback<AlertMetric> rowCallback, @Nonnull PageRequest pageRequest) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(AlertMetric.class);
        Root root = criteriaQuery.from(InternalAlert.class);
        Expression count = builder.count((Expression)root.get(InternalAlert_.id));
        Path issueId = root.get(InternalAlert_.issueId);
        Path severity = root.get(InternalAlert_.issueSeverity);
        Path node = root.get(InternalAlert_.nodeName);
        Path pluginKey = root.get(InternalAlert_.triggerPluginKey);
        Path pluginVersion = root.get(InternalAlert_.triggerPluginVersion);
        Expression isNullPluginVersion = builder.selectCase().when((Expression)builder.isNull((Expression)pluginVersion), (Object)1).otherwise((Object)0);
        List<Predicate> predicates = this.getCriteriaPredicates(builder, (Root<InternalAlert>)root, criteria);
        Query query = this.session().createQuery(criteriaQuery.select((Selection)builder.construct(AlertMetric.class, new Selection[]{issueId, severity, pluginKey, pluginVersion, node, count})).where(predicates.toArray(new Predicate[0])).groupBy(new Expression[]{issueId, severity, pluginKey, pluginVersion, node}).orderBy(new Order[]{builder.desc((Expression)severity), builder.asc((Expression)issueId), builder.asc((Expression)pluginKey), builder.desc(isNullPluginVersion), builder.asc((Expression)pluginVersion), builder.asc((Expression)node)})).setFirstResult(pageRequest.getStart()).setMaxResults(pageRequest.getLimit() + 1);
        this.scrollQuery(query, value -> rowCallback.onRow((Object)((AlertMetric)value.get(0))) == CallbackResult.DONE);
    }

    public void streamMinimalAlerts(@Nonnull AlertCriteria alertCriteria, @Nonnull RowCallback<MinimalAlertEntity> rowCallback, @Nonnull PageRequest pageRequest) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(SimpleMinimalAlertEntity.class);
        Root root = criteriaQuery.from(InternalAlert.class);
        Path id = root.get(InternalAlert_.id);
        Path timestamp = root.get(InternalAlert_.timestamp);
        Path issueId = root.get(InternalAlert_.issueId);
        Path nodeName = root.get(InternalAlert_.nodeName);
        Path pluginKey = root.get(InternalAlert_.triggerPluginKey);
        Path details = root.get(InternalAlert_.detailsJson);
        Expression detailsLength = builder.selectCase().when((Expression)builder.isNull((Expression)details), (Object)0).otherwise(builder.length((Expression)details));
        List<Predicate> predicates = this.getCriteriaPredicates(builder, (Root<InternalAlert>)root, alertCriteria);
        Query query = this.session().createQuery(criteriaQuery.select((Selection)builder.construct(SimpleMinimalAlertEntity.class, new Selection[]{id, timestamp, issueId, pluginKey, nodeName, detailsLength})).where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.desc((Expression)timestamp), builder.desc((Expression)id)}));
        this.scrollQuery(query, value -> {
            SimpleMinimalAlertEntity row = (SimpleMinimalAlertEntity)value.get(0);
            return rowCallback.onRow((Object)row) == CallbackResult.DONE;
        });
    }

    public void streamByIds(@Nonnull Collection<Long> ids, @Nonnull RowCallback<AlertEntity> rowCallback) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery alertCriteriaQuery = builder.createQuery(InternalAlert.class);
        Root root = alertCriteriaQuery.from(InternalAlert.class);
        Path id = root.get(InternalAlert_.id);
        Path timestamp = root.get(InternalAlert_.timestamp);
        MutableBoolean done = new MutableBoolean(false);
        ArrayList<Long> sortedIds = new ArrayList<Long>(ids);
        sortedIds.sort(Comparator.comparingLong(Long::longValue).reversed());
        for (Collection partition : Iterables.partition(sortedIds, (int)500)) {
            CriteriaBuilder.In inClause = builder.in((Expression)id);
            partition.forEach(arg_0 -> ((CriteriaBuilder.In)inClause).value(arg_0));
            Query alertQuery = this.session().createQuery(alertCriteriaQuery.select((Selection)root).where((Expression)inClause).orderBy(new Order[]{builder.desc((Expression)timestamp), builder.desc((Expression)id)}));
            this.scrollQuery(alertQuery, value -> {
                InternalAlert alert = (InternalAlert)value.get(0);
                done.setValue(rowCallback.onRow((Object)alert) == CallbackResult.DONE);
                return done.getValue();
            });
            if (!done.isTrue()) continue;
            break;
        }
    }

    @Nonnull
    public InternalAlert save(@Nonnull Alert alert) {
        return (InternalAlert)this.create(new InternalAlert(alert));
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }

    private static Set<String> toLower(Set<String> values) {
        return (Set)values.stream().map(value -> StringUtils.lowerCase((String)value, (Locale)Locale.ROOT)).collect(MoreCollectors.toImmutableSet());
    }

    private List<Predicate> getCriteriaPredicates(CriteriaBuilder builder, Root<InternalAlert> root, AlertCriteria criteria) {
        Path timestamp = root.get(InternalAlert_.timestamp);
        ArrayList<Predicate> result = new ArrayList<Predicate>();
        if (!criteria.getComponentIds().isEmpty()) {
            result.add(root.get(InternalAlert_.issueComponentId).in((Collection)criteria.getComponentIds()));
        }
        if (!criteria.getIssueIds().isEmpty()) {
            result.add(root.get(InternalAlert_.issueId).in((Collection)criteria.getIssueIds()));
        }
        if (!criteria.getNodeNames().isEmpty()) {
            result.add(root.get(InternalAlert_.nodeNameLower).in(HibernateAlertDao.toLower(criteria.getNodeNames())));
        }
        if (!criteria.getPluginKeys().isEmpty()) {
            result.add(root.get(InternalAlert_.triggerPluginKeyLower).in(HibernateAlertDao.toLower(criteria.getPluginKeys())));
        }
        if (!criteria.getSeverities().isEmpty()) {
            result.add(root.get(InternalAlert_.issueSeverity).in((Collection)criteria.getSeverities()));
        }
        criteria.getSince().ifPresent(since -> result.add(builder.greaterThan((Expression)timestamp, (Comparable)Long.valueOf(since.toEpochMilli()))));
        criteria.getUntil().ifPresent(until -> result.add(builder.lessThanOrEqualTo((Expression)timestamp, (Comparable)Long.valueOf(until.toEpochMilli()))));
        return result;
    }

    private static <T> Function<Object, T> itemAt(int index, Class<T> clazz) {
        return row -> {
            Object[] data = (Object[])row;
            return index < data.length ? clazz.cast(data[index]) : null;
        };
    }
}

