/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.emoticon;

import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.emoticon.EmoticonDao;
import com.atlassian.stash.internal.emoticon.InternalEmoticon;
import com.atlassian.stash.internal.util.LikeQueryHelper;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository(value="emoticonDao")
public class HibernateEmoticonDao
extends AbstractHibernateDao<String, InternalEmoticon>
implements EmoticonDao {
    public HibernateEmoticonDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public void deleteBatch(@Nonnull Iterable<InternalEmoticon> emoticons) {
        for (List partition : Lists.partition(MoreStreams.streamIterable(emoticons).map(InternalEmoticon::getId).collect(Collectors.toList()), (int)100)) {
            this.session().createQuery("delete from InternalEmoticon where id in (:ids)").setParameterList("ids", (Collection)partition).executeUpdate();
        }
    }

    @Nonnull
    public Page<InternalEmoticon> find(@Nonnull String pattern, @Nonnull PageRequest pageRequest) {
        String hql = "from InternalEmoticon where id like lower(:pattern) escape '!' order by id asc";
        Query query = this.session().createQuery(hql, InternalEmoticon.class).setParameter("pattern", (Object)LikeQueryHelper.matchesStart(this.session(), pattern));
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    @Nonnull
    public Page<InternalEmoticon> findByProvider(@Nonnull String provider, @Nonnull PageRequest pageRequest) {
        String hql = "from InternalEmoticon where provider = :provider";
        Query query = this.session().createQuery(hql, InternalEmoticon.class).setParameter("provider", (Object)provider);
        query.setCacheMode(CacheMode.IGNORE);
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }
}

