/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.group;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.group.DeletedGroupDao;
import com.atlassian.stash.internal.group.InternalDeletedGroup;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="deletedGroupDao")
public class HibernateDeletedGroupDao
extends AbstractHibernateDao<Integer, InternalDeletedGroup>
implements DeletedGroupDao {
    private static final String FIELD_DELETED_DATE = "deletedDate";
    private static final String FIELD_NAME = "name";
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.asc((String)"deletedDate"));

    @Autowired
    public HibernateDeletedGroupDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }

    @Nonnull
    public Page<InternalDeletedGroup> findByDeletedDateEarlierThan(@Nonnull Date date, @Nonnull PageRequest pageRequest) {
        Query query = this.session().createQuery("from InternalDeletedGroup where deletedDate < :deletedDate order by name").setParameter(FIELD_DELETED_DATE, (Object)date);
        return this.pageQuery(query, pageRequest);
    }

    @Nullable
    public InternalDeletedGroup findByName(@Nonnull String name) {
        return (InternalDeletedGroup)this.session().createQuery("from InternalDeletedGroup where name = :name").setParameter(FIELD_NAME, (Object)IdentifierUtils.toLowerCase((String)name)).uniqueResult();
    }
}

