/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class DelegatingRegionFactory
implements RegionFactory {
    public static final String PROP_REGION_FACTORY = "bitbucket.cache.region.factory";
    private final RegionFactory delegate;

    public DelegatingRegionFactory(Properties properties) {
        this.delegate = (RegionFactory)properties.get(PROP_REGION_FACTORY);
    }

    public DomainDataRegion buildDomainDataRegion(DomainDataRegionConfig regionConfig, DomainDataRegionBuildingContext buildingContext) {
        return this.delegate.buildDomainDataRegion(regionConfig, buildingContext);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, SessionFactoryImplementor sessionFactory) {
        return this.delegate.buildQueryResultsRegion(regionName, sessionFactory);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, SessionFactoryImplementor sessionFactory) {
        return this.delegate.buildTimestampsRegion(regionName, sessionFactory);
    }

    public AccessType getDefaultAccessType() {
        return this.delegate.getDefaultAccessType();
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return this.delegate.isMinimalPutsEnabledByDefault();
    }

    public long nextTimestamp() {
        return this.delegate.nextTimestamp();
    }

    public String qualify(String regionName) {
        return this.delegate.qualify(regionName);
    }

    public void start(SessionFactoryOptions settings, Map configValues) throws CacheException {
        if (this.delegate == null) {
            throw new CacheException("[bitbucket.cache.region.factory] was not configured");
        }
        this.delegate.start(settings, configValues);
    }

    public void stop() {
        this.delegate.stop();
    }
}

