/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import com.atlassian.stash.internal.hibernate.EntityCache;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.lang3.StringUtils;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ConfigurationBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.jsr107.Eh107Configuration;
import org.ehcache.jsr107.EhcacheCachingProvider;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.jcache.MissingCacheStrategy;
import org.hibernate.cache.jcache.internal.JCacheRegionFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class EhcacheRegionFactory
extends JCacheRegionFactory
implements EnvironmentAware {
    private Environment environment;
    private MissingCacheStrategy missingCacheStrategy;

    public void setEnvironment(@Nonnull Environment environment) {
        this.environment = environment;
    }

    protected Cache<Object, Object> createCache(String regionName) {
        CacheConfiguration configuration;
        if (this.missingCacheStrategy == MissingCacheStrategy.FAIL) {
            throw new CacheException("The [" + regionName + "] L2 cache region has not been configured; see " + EntityCache.class.getSimpleName());
        }
        if (regionName.startsWith("query.")) {
            configuration = this.boundedCache("query.*");
        } else {
            ResourcePools pools = EhcacheRegionFactory.heap(this.getSize("entity.*"));
            configuration = CacheConfigurationBuilder.newCacheConfigurationBuilder(Object.class, Object.class, (ResourcePools)pools).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofMinutes(30L))).build();
        }
        return this.getCacheManager().createCache(regionName, Eh107Configuration.fromEhcacheCacheConfiguration(configuration));
    }

    protected void prepareForUse(SessionFactoryOptions settings, Map configValues) {
        super.prepareForUse(settings, configValues);
        this.missingCacheStrategy = MissingCacheStrategy.interpretSetting(configValues == null ? null : configValues.get("hibernate.javax.cache.missing_cache_strategy"));
    }

    protected CacheManager resolveCacheManager(SessionFactoryOptions settings, Map properties) {
        EhcacheCachingProvider provider = (EhcacheCachingProvider)Caching.getCachingProvider((String)EhcacheCachingProvider.class.getName());
        return provider.getCacheManager(provider.getDefaultURI(), this.buildConfiguration());
    }

    private static ResourcePools heap(int size) {
        return ResourcePoolsBuilder.heap((long)size).build();
    }

    private ConfigurationBuilder addCache(ConfigurationBuilder builder, EntityCache cache) {
        return this.addCache(builder, cache.getName());
    }

    private ConfigurationBuilder addCache(ConfigurationBuilder builder, String name) {
        return builder.addCache(name, this.boundedCache(name));
    }

    private CacheConfiguration<Object, Object> boundedCache(String name) {
        ExpiryPolicy expiryPolicy;
        int timeToIdleSeconds = this.getTimeout(name + ".tti");
        int timeToLiveSeconds = this.getTimeout(name + ".ttl");
        int size = this.getSize(name);
        if (timeToIdleSeconds == 0) {
            expiryPolicy = timeToLiveSeconds == 0 ? ExpiryPolicyBuilder.noExpiration() : ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofSeconds(timeToLiveSeconds));
        } else if (timeToLiveSeconds == 0) {
            expiryPolicy = ExpiryPolicyBuilder.timeToIdleExpiration((Duration)Duration.ofSeconds(timeToIdleSeconds));
        } else {
            Duration tti = Duration.ofSeconds(timeToIdleSeconds);
            Duration ttl = Duration.ofSeconds(timeToLiveSeconds);
            expiryPolicy = ExpiryPolicyBuilder.expiry().access(tti).create(ttl).update(tti).build();
        }
        return CacheConfigurationBuilder.newCacheConfigurationBuilder(Object.class, Object.class, (ResourcePools)EhcacheRegionFactory.heap(size)).withExpiry(expiryPolicy).build();
    }

    private Configuration buildConfiguration() {
        ConfigurationBuilder builder = ConfigurationBuilder.newConfigurationBuilder().addCache("default-update-timestamps-region", CacheConfigurationBuilder.newCacheConfigurationBuilder(Object.class, Object.class, (ResourcePools)EhcacheRegionFactory.heap(Integer.MAX_VALUE)).withExpiry(ExpiryPolicyBuilder.noExpiration()).build()).addCache("default-query-results-region", this.boundedCache("org.hibernate.cache.internal.StandardQueryCache"));
        for (EntityCache cache : EntityCache.values()) {
            builder = this.addCache(builder, cache);
        }
        return builder.build();
    }

    private String getProperty(String suffix) {
        return this.environment.getProperty("cache." + suffix);
    }

    private int getSize(String cacheName) {
        String maxSize = this.getProperty(cacheName + ".max");
        if (StringUtils.isBlank((CharSequence)maxSize)) {
            return 500;
        }
        int configured = Integer.parseInt(maxSize);
        return configured > 0 ? configured : Integer.MAX_VALUE;
    }

    private int getTimeout(String timeoutName) {
        String timeout = this.getProperty(timeoutName);
        if (StringUtils.isBlank((CharSequence)timeout)) {
            return 0;
        }
        return Math.max(Integer.parseInt(timeout), 0);
    }
}

