/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshNodeRegistry;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.stash.internal.mesh.InternalMeshNode;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryOfflineSupplier;
import com.atlassian.stash.internal.user.InternalNormalUser;
import jakarta.annotation.Nonnull;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.event.internal.DefaultLoadEventListener;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class EntityEnrichingLoadListener
extends DefaultLoadEventListener
implements ApplicationContextAware,
PostLoadEventListener {
    private static final Logger log = LoggerFactory.getLogger(EntityEnrichingLoadListener.class);
    private final String crowdServiceBeanName;
    private final Object lock;
    private ApplicationContext applicationContext;
    private volatile CrowdService crowdService;
    private volatile DmzMeshNodeRegistry nodeRegistry;
    private volatile RepositoryOfflineSupplier repositoryOfflineSupplier;

    public EntityEnrichingLoadListener(String crowdServiceBeanName) {
        this.crowdServiceBeanName = crowdServiceBeanName;
        this.lock = new Object();
    }

    public void onLoad(LoadEvent event, LoadEventListener.LoadType loadType) throws HibernateException {
        super.onLoad(event, loadType);
        Object entity = event.getResult();
        if (Hibernate.isInitialized((Object)entity)) {
            this.maybeEnrich(entity);
        }
    }

    public void onPostLoad(PostLoadEvent event) {
        this.maybeEnrich(event.getEntity());
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User getCrowdUser(String username) {
        if (username == null) {
            return null;
        }
        if (this.crowdService == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.crowdService == null) {
                    this.crowdService = (CrowdService)this.applicationContext.getBean(this.crowdServiceBeanName, CrowdService.class);
                }
            }
        }
        try {
            return this.crowdService.getUser(username);
        }
        catch (ObjectNotFoundException e) {
            log.debug("Loading the associated crowd user with name '{}' failed", (Object)username, (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DmzMeshNodeRegistry getNodeRegistry() {
        if (this.nodeRegistry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.nodeRegistry == null) {
                    this.nodeRegistry = (DmzMeshNodeRegistry)this.applicationContext.getBean(DmzMeshNodeRegistry.class);
                }
            }
        }
        return this.nodeRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepositoryOfflineSupplier getRepositoryOfflineSupplier() {
        if (this.repositoryOfflineSupplier == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.repositoryOfflineSupplier == null) {
                    this.repositoryOfflineSupplier = (RepositoryOfflineSupplier)this.applicationContext.getBean(RepositoryOfflineSupplier.class);
                }
            }
        }
        return this.repositoryOfflineSupplier;
    }

    private void maybeEnrich(Object loaded) {
        if (loaded instanceof InternalNormalUser) {
            InternalNormalUser user = (InternalNormalUser)loaded;
            if (!user.isCrowdBacked()) {
                user.setBackingCrowdUser(this.getCrowdUser(user.getUsername()));
            }
        } else if (loaded instanceof InternalRepository) {
            ((InternalRepository)loaded).setOfflineSupplier(this.getRepositoryOfflineSupplier());
        } else if (loaded instanceof InternalMeshNode) {
            ((InternalMeshNode)loaded).setNodeRegistry(this.getNodeRegistry());
        }
    }
}

