/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import com.atlassian.stash.internal.repository.RepositoryScope;
import com.atlassian.stash.internal.repository.RepositoryScopedIdGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import jakarta.annotation.Nonnull;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.stereotype.Component;

@Component(value="repositoryScopedIdGenerator")
public class HibernateRepositoryScopedIdGenerator
implements RepositoryScopedIdGenerator {
    public static final String COLUMN_NEXT_ID = "next_id";
    public static final String COLUMN_REPOSITORY_ID = "repository_id";
    public static final String COLUMN_SCOPE_TYPE = "scope_type";
    public static final long FIRST_ID = 1L;
    public static final String TABLE_NAME = "sta_repository_scoped_id";
    private static final String ALIAS = "rsi";
    private static final String INSERT_SQL = "insert into sta_repository_scoped_id (repository_id, scope_type, next_id) values (?, ?, ?)";
    private static final LockOptions LOCK_OPTIONS = new LockOptions(LockMode.PESSIMISTIC_WRITE).setAliasSpecificLockMode("rsi", LockMode.PESSIMISTIC_WRITE);
    private static final String SELECT_SQL = "select " + StringHelper.qualify((String)"rsi", (String)"next_id") + " from sta_repository_scoped_id rsi where " + StringHelper.qualify((String)"rsi", (String)"repository_id") + " = ? and " + StringHelper.qualify((String)"rsi", (String)"scope_type") + " = ?";
    private static final Map<String, String[]> UPDATED_COLUMNS = ImmutableMap.builder().put((Object)"rsi", (Object)new String[]{"next_id"}).build();
    private static final String UPDATE_SQL = "update sta_repository_scoped_id set next_id = ? where repository_id = ? and scope_type = ? and next_id = ?";
    private static final Logger log = LoggerFactory.getLogger(HibernateRepositoryScopedIdGenerator.class);
    private final SQLExceptionTranslator exceptionTranslator;
    private final SessionFactoryImplementor sessionFactory;
    private final SqlStatementLogger statementLogger;

    @Autowired
    public HibernateRepositoryScopedIdGenerator(SessionFactoryImplementor sessionFactory, SQLExceptionTranslator sqlExceptionTranslator) {
        this.sessionFactory = sessionFactory;
        this.exceptionTranslator = sqlExceptionTranslator;
        this.statementLogger = ((JdbcServices)sessionFactory.getServiceRegistry().getService(JdbcServices.class)).getSqlStatementLogger();
    }

    public long nextId(int repositoryId, @Nonnull RepositoryScope scope) {
        Objects.requireNonNull(scope, "scope");
        SessionImplementor session = (SessionImplementor)this.sessionFactory.getCurrentSession();
        return (Long)session.getTransactionCoordinator().createIsolationDelegate().delegateWork((WorkExecutorVisitable)new Generator(repositoryId, scope), true);
    }

    public void setNextId(long nextId, int repositoryId, RepositoryScope scope) {
        Objects.requireNonNull(scope, "scope");
        SessionImplementor session = (SessionImplementor)this.sessionFactory.getCurrentSession();
        log.debug("Re-syncing next ID of repository {} to {} for scope {}", new Object[]{repositoryId, nextId, scope});
        session.getTransactionCoordinator().createIsolationDelegate().delegateWork((WorkExecutorVisitable)new Updater(this, Ints.saturatedCast((long)nextId), repositoryId, scope), true);
    }

    public void prepare(int repositoryId) {
        Session session = this.sessionFactory.getCurrentSession();
        session.doWork((Work)new Preparer(repositoryId));
    }

    private Dialect getDialect() {
        return ((JdbcServices)this.sessionFactory.getServiceRegistry().getService(JdbcServices.class)).getDialect();
    }

    private void logStatement(String sql) {
        this.statementLogger.logStatement(sql, FormatStyle.BASIC.getFormatter());
    }

    private class Generator
    extends AbstractReturningWork<Long> {
        protected final IntegralDataTypeHolder id = IdentifierGeneratorHelper.getIntegralDataTypeHolder(Long.class);
        protected final int repositoryId;
        protected final RepositoryScope scope;

        private Generator(int repositoryId, RepositoryScope scope) {
            this.repositoryId = repositoryId;
            this.scope = scope;
        }

        public Long execute(Connection connection) throws HibernateException {
            boolean updated;
            do {
                try {
                    this.selectNextId(connection);
                    updated = this.updateNextId(connection);
                }
                catch (SQLException e) {
                    throw new HibernateException("The next ID for the [" + this.scope.getType() + "] scope in repository [" + this.repositoryId + "] could not be generated", (Throwable)e);
                }
            } while (!updated);
            return (Long)this.id.makeValue();
        }

        protected void selectNextId(Connection connection) throws SQLException {
            Dialect dialect = HibernateRepositoryScopedIdGenerator.this.getDialect();
            String selectSql = dialect.applyLocksToSql(SELECT_SQL, LOCK_OPTIONS, UPDATED_COLUMNS);
            HibernateRepositoryScopedIdGenerator.this.logStatement(selectSql);
            try (PreparedStatement select = connection.prepareStatement(selectSql);){
                select.setInt(1, this.repositoryId);
                select.setString(2, this.scope.getType());
                try (ResultSet results = select.executeQuery();){
                    if (results.next()) {
                        this.id.initialize(results, 1L);
                    } else {
                        this.insertFirstId(connection);
                    }
                }
            }
        }

        protected boolean updateNextId(Connection connection) throws SQLException {
            return this.updateNextId(connection, this.id.copy().increment());
        }

        protected boolean updateNextId(Connection connection, IntegralDataTypeHolder nextId) throws SQLException {
            HibernateRepositoryScopedIdGenerator.this.logStatement(HibernateRepositoryScopedIdGenerator.UPDATE_SQL);
            try (PreparedStatement update = connection.prepareStatement(HibernateRepositoryScopedIdGenerator.UPDATE_SQL);){
                nextId.bind(update, 1);
                update.setInt(2, this.repositoryId);
                update.setString(3, this.scope.getType());
                this.id.bind(update, 4);
                boolean bl = update.executeUpdate() > 0;
                return bl;
            }
        }

        private void insertFirstId(Connection connection) throws SQLException {
            this.id.initialize(1L);
            HibernateRepositoryScopedIdGenerator.this.logStatement(HibernateRepositoryScopedIdGenerator.INSERT_SQL);
            try (PreparedStatement insert = connection.prepareStatement(HibernateRepositoryScopedIdGenerator.INSERT_SQL);){
                insert.setInt(1, this.repositoryId);
                insert.setString(2, this.scope.getType());
                this.id.bind(insert, 3);
                insert.execute();
            }
            catch (SQLException e) {
                DataAccessException exception = HibernateRepositoryScopedIdGenerator.this.exceptionTranslator.translate(null, HibernateRepositoryScopedIdGenerator.INSERT_SQL, e);
                if (exception instanceof DataIntegrityViolationException) {
                    this.selectNextId(connection);
                }
                throw e;
            }
        }
    }

    private class Updater
    extends Generator {
        private final IntegralDataTypeHolder newId;

        private Updater(HibernateRepositoryScopedIdGenerator hibernateRepositoryScopedIdGenerator, int newId, int repositoryId, RepositoryScope scope) {
            super(repositoryId, scope);
            Preconditions.checkArgument((newId > 0 ? 1 : 0) != 0, (Object)"newId must be positive");
            this.newId = IdentifierGeneratorHelper.getIntegralDataTypeHolder(Long.class).initialize((long)newId);
        }

        @Override
        protected boolean updateNextId(Connection connection) throws SQLException {
            if (this.id.gt(this.newId) || this.id.eq(this.newId)) {
                return true;
            }
            boolean updated = this.updateNextId(connection, this.newId);
            if (updated) {
                this.id.initialize(((Long)this.newId.makeValue()).longValue());
            }
            return updated;
        }
    }

    private class Preparer
    implements Work {
        private final int repositoryId;

        public Preparer(int repositoryId) {
            this.repositoryId = repositoryId;
        }

        public void execute(Connection connection) throws SQLException {
            HibernateRepositoryScopedIdGenerator.this.logStatement(HibernateRepositoryScopedIdGenerator.INSERT_SQL);
            try (PreparedStatement insert = connection.prepareStatement(HibernateRepositoryScopedIdGenerator.INSERT_SQL);){
                for (RepositoryScope scope : RepositoryScope.values()) {
                    insert.setInt(1, this.repositoryId);
                    insert.setString(2, scope.getType());
                    insert.setLong(3, 1L);
                    insert.addBatch();
                }
                insert.executeBatch();
            }
        }
    }
}

