/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate.dialect.resolver;

import com.atlassian.stash.internal.hibernate.dialect.CustomH2Dialect;
import com.atlassian.stash.internal.hibernate.dialect.CustomHSQLDialect;
import com.atlassian.stash.internal.hibernate.dialect.CustomOracle12cDialect;
import com.atlassian.stash.internal.hibernate.dialect.CustomPostgres95Dialect;
import com.atlassian.stash.internal.hibernate.dialect.CustomSqlServer2012Dialect;
import jakarta.annotation.Nullable;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDialectResolver
implements DialectResolver {
    private static final Logger log = LoggerFactory.getLogger(CustomDialectResolver.class);

    public Dialect resolveDialect(DialectResolutionInfo info) {
        String databaseName;
        Object dialect = switch (databaseName = info.getDatabaseName()) {
            case "H2" -> new CustomH2Dialect();
            case "HSQL Database Engine" -> new CustomHSQLDialect();
            case "PostgreSQL" -> new CustomPostgres95Dialect();
            case "Oracle" -> new CustomOracle12cDialect();
            default -> databaseName.startsWith("Microsoft SQL Server") ? new CustomSqlServer2012Dialect() : null;
        };
        log.debug("Returning {} for {} (Version: {}.{})", new Object[]{CustomDialectResolver.getDialectName((Dialect)dialect), databaseName, info.getDatabaseMajorVersion(), info.getDatabaseMinorVersion()});
        return dialect;
    }

    private static String getDialectName(@Nullable Dialect dialect) {
        if (dialect == null) {
            return "null";
        }
        return dialect.getClass().getSimpleName();
    }
}

