/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hikari;

import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.hikari.ExtendedHikariDataSource;
import com.atlassian.stash.internal.jdbc.CloseableDataSource;
import com.atlassian.stash.internal.jdbc.ConnectionTracker;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.atlassian.stash.internal.jdbc.DataSourceFactory;
import com.zaxxer.hikari.HikariConfig;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.AbstractDriverBasedDataSource;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class HikariDataSourceFactory
extends HikariConfig
implements DataSourceFactory {
    private final ConnectionTracker tracker;
    private Duration validationConnectionTimeout;

    public HikariDataSourceFactory(ConnectionTracker tracker) {
        this.tracker = tracker;
        this.validationConnectionTimeout = Duration.ofSeconds(5L);
    }

    @Nonnull
    public DataSource create(@Nonnull DataSourceConfiguration configuration) {
        HikariConfig config = new HikariConfig();
        this.copyStateTo(config);
        config.setDataSourceProperties(configuration.getProperties());
        config.setDriverClassName(configuration.getDriverClassName());
        config.setJdbcUrl(configuration.getUrl());
        config.setPassword(configuration.getPassword());
        config.setUsername(configuration.getUser());
        ExtendedHikariDataSource dataSource = new ExtendedHikariDataSource(config, this.tracker);
        LazyConnectionDataSourceProxy proxy = new LazyConnectionDataSourceProxy();
        proxy.setDefaultAutoCommit(this.isAutoCommit());
        proxy.setDefaultTransactionIsolationName(this.getTransactionIsolation());
        proxy.setTargetDataSource((DataSource)((Object)dataSource));
        proxy.afterPropertiesSet();
        return proxy;
    }

    @Nonnull
    public CloseableDataSource createForValidation(@Nonnull DataSourceConfiguration configuration) {
        SingleConnectionDataSource dataSource = new SingleConnectionDataSource();
        dataSource.setConnectionProperties(configuration.getProperties());
        dataSource.setDriverClassName(configuration.getDriverClassName());
        dataSource.setPassword(configuration.getPassword());
        dataSource.setUrl(configuration.getUrl());
        dataSource.setUsername(configuration.getUser());
        DbType.forDriver((String)configuration.getDriverClassName()).ifPresent(type -> type.applyTimeout((AbstractDriverBasedDataSource)dataSource, this.validationConnectionTimeout));
        return new DelegatingCloseableDataSource(dataSource);
    }

    public void setValidationConnectionTimeout(long validationConnectionTimeout) {
        this.validationConnectionTimeout = Duration.ofSeconds(validationConnectionTimeout);
    }

    private static class DelegatingCloseableDataSource
    extends DelegatingDataSource
    implements CloseableDataSource {
        DelegatingCloseableDataSource(SingleConnectionDataSource dataSource) {
            super((DataSource)dataSource);
        }

        public void close() {
            DataSource target = this.getTargetDataSource();
            if (target != null) {
                ((SingleConnectionDataSource)target).destroy();
            }
        }
    }
}

