/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.script;

import com.atlassian.bitbucket.hook.script.HookScriptType;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.hook.script.HookScriptConfigCriteria;
import com.atlassian.stash.internal.hook.script.HookScriptConfigDao;
import com.atlassian.stash.internal.hook.script.InternalHookScript;
import com.atlassian.stash.internal.hook.script.InternalHookScriptConfig;
import com.atlassian.stash.internal.scope.Scopeable;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.stream.Stream;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository(value="hookScriptConfigDao")
public class HibernateHookScriptConfigDao
extends AbstractHibernateDao<Long, InternalHookScriptConfig>
implements HookScriptConfigDao {
    public HibernateHookScriptConfigDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public int deleteByScope(@Nonnull Scope s) {
        Scopeable scope = Scopeable.fromScope((Scope)s);
        String hql = "delete from InternalHookScriptConfig where " + (scope == null ? "scope is null" : "scope = :scope");
        Query query = this.session().createQuery(hql);
        if (scope != null) {
            query.setParameter("scope", (Object)scope);
        }
        return query.executeUpdate();
    }

    public int deleteByScopeAndScript(@Nonnull Scope s, @Nonnull InternalHookScript script) {
        Scopeable scope = Scopeable.fromScope((Scope)s);
        String hql = "delete from InternalHookScriptConfig where script.id = :scriptId and " + (scope == null ? "scope is null" : "scope = :scope");
        Query query = this.session().createQuery(hql).setParameter("scriptId", (Object)script.getId());
        if (scope != null) {
            query.setParameter("scope", (Object)scope);
        }
        return query.executeUpdate();
    }

    @Nonnull
    public Page<InternalHookScriptConfig> findByScope(@Nonnull Scope s, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(s, "scope");
        Objects.requireNonNull(pageRequest, "pageRequest");
        Scopeable scope = Scopeable.fromScope((Scope)s);
        String hql = "from InternalHookScriptConfig where " + (scope == null ? "scope is null" : "scope = :scope") + " order by script.id";
        Query query = this.session().createQuery(hql, InternalHookScriptConfig.class).setCacheMode(CacheMode.GET);
        if (scope != null) {
            query.setParameter("scope", (Object)scope);
        }
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    public InternalHookScriptConfig findByScopeAndScript(@Nonnull Scope s, @Nonnull InternalHookScript script) {
        Scopeable scope = Scopeable.fromScope((Scope)s);
        String hql = "from InternalHookScriptConfig where script.id = :scriptId and " + (scope == null ? "scope is null" : "scope = :scope");
        Query query = this.session().createQuery(hql, InternalHookScriptConfig.class).setParameter("scriptId", (Object)script.getId());
        if (scope != null) {
            query.setParameter("scope", (Object)scope);
        }
        return (InternalHookScriptConfig)HibernateUtils.initialize((Object)((InternalHookScriptConfig)query.uniqueResult()));
    }

    @Nonnull
    public Stream<InternalHookScriptConfig> stream(@Nonnull HookScriptConfigCriteria criteria) {
        Scopeable scope = Scopeable.fromScope((Scope)criteria.getScope());
        HookScriptType type = criteria.getType();
        String hql = "from InternalHookScriptConfig where " + (scope == null ? "scope is null" : "scope = :scope") + (type == null ? "" : " and script.type = :type") + " order by script.id";
        Query query = this.session().createQuery(hql, InternalHookScriptConfig.class);
        if (scope != null) {
            query.setParameter("scope", (Object)scope);
        }
        if (type != null) {
            query.setParameter("type", (Object)type);
        }
        return query.setCacheMode(CacheMode.GET).setFetchSize(100).setMaxResults(0x7FFFFFFE).stream().map(HibernateUtils::initialize);
    }
}

