/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.script;

import com.atlassian.bitbucket.hook.script.MinimalHookScript;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.hook.script.HookScriptDao;
import com.atlassian.stash.internal.hook.script.InternalHookScript;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository(value="hookScriptDao")
public class HibernateHookScriptDao
extends AbstractHibernateDao<Long, InternalHookScript>
implements HookScriptDao {
    public HibernateHookScriptDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public Set<MinimalHookScript> deleteByPluginKey(@Nonnull String pluginKey) {
        String hql = "select new com.atlassian.stash.internal.hook.script.SimpleMinimalHookScript(id, version) from InternalHookScript where pluginKey = :pluginKey order by id";
        List scripts = this.session().createQuery(hql, MinimalHookScript.class).setParameter("pluginKey", (Object)pluginKey).list();
        if (scripts.isEmpty()) {
            return Collections.emptySet();
        }
        for (List partition : Lists.partition((List)Lists.transform((List)scripts, MinimalHookScript::getId), (int)100)) {
            this.session().createQuery("delete from InternalHookScript where id in (:ids)").setParameterList("ids", (Collection)partition).executeUpdate();
        }
        return ImmutableSet.copyOf((Collection)scripts);
    }

    @Nonnull
    public Page<InternalHookScript> findByPluginKey(@Nonnull String pluginKey, @Nonnull PageRequest pageRequest) {
        String hql = "from InternalHookScript where pluginKey = :pluginKey order by id";
        Query query = this.session().createQuery(hql, InternalHookScript.class).setParameter("pluginKey", (Object)pluginKey);
        return this.pageQuery(query, pageRequest);
    }

    @Nonnull
    public Set<MinimalHookScript> getAll() {
        String hql = "select new com.atlassian.stash.internal.hook.script.SimpleMinimalHookScript(id, version) from InternalHookScript order by id";
        List scripts = this.session().createQuery(hql, MinimalHookScript.class).list();
        return ImmutableSet.copyOf((Collection)scripts);
    }

    public int updatePluginKey(@Nonnull String oldPluginKey, @Nonnull String newPluginKey) {
        String hql = "update InternalHookScript set pluginKey = :newPluginKey where pluginKey = :oldPluginKey";
        return this.session().createQuery(hql).setParameter("oldPluginKey", (Object)oldPluginKey).setParameter("newPluginKey", (Object)newPluginKey).executeUpdate();
    }
}

