/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.bitbucket.idx.CommitIndexer;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.idx.IndexerStateDao;
import com.atlassian.stash.internal.idx.InternalIndexerState;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="indexerStateDao")
public class HibernateIndexerStateDao
extends AbstractHibernateDao<InternalIndexerState.PK, InternalIndexerState>
implements IndexerStateDao {
    public static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.asc((String)"indexerId"));

    @Autowired
    public HibernateIndexerStateDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public Long getOldestLastRunTimestamp(@Nonnull InternalRepository repository, @Nonnull Collection<CommitIndexer> indexers) {
        Set indexerIds = indexers.stream().map(CommitIndexer::getId).collect(Collectors.toSet());
        if (indexerIds.isEmpty()) {
            return null;
        }
        Query query = this.session().createQuery("select count(indexerId), min(lastRun) from InternalIndexerState where indexerId in (:ids) and repository.id = :repo_id").setParameterList("ids", indexerIds).setParameter("repo_id", (Object)repository.getId());
        Object[] result = (Object[])query.uniqueResult();
        if (result != null) {
            Number count = (Number)result[0];
            Long lastRun = (Long)result[1];
            if (indexerIds.size() <= count.intValue()) {
                return lastRun;
            }
        }
        return null;
    }

    public Long getLastRunTimestamp(@Nonnull InternalRepository repository, @Nonnull CommitIndexer indexer) {
        InternalIndexerState state = (InternalIndexerState)this.getById((Serializable)new InternalIndexerState.PK(indexer.getId(), repository.getId()));
        return state == null ? null : state.getLastRun();
    }

    @Nonnull
    public Set<Long> getReferencedLastRunTimestamps(@Nonnull InternalRepository repository) {
        Query query = this.session().createQuery("select distinct lastRun from InternalIndexerState where repository.id = :repoId").setParameter("repoId", (Object)repository.getId());
        return ImmutableSet.copyOf((Collection)query.list());
    }

    public void setLastRunTimestamp(@Nonnull InternalRepository repository, @Nonnull CommitIndexer indexer, long timestamp) {
        this.update(new InternalIndexerState(indexer.getId(), repository, Long.valueOf(timestamp)));
    }

    public void setLastRunTimestamp(@Nonnull InternalRepository repository, @Nonnull Collection<CommitIndexer> indexers, long timestamp) {
        indexers.forEach(indexer -> this.setLastRunTimestamp(repository, (CommitIndexer)indexer, timestamp));
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

