/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.integrity;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.integrity.ApplicationIntegrityDao;
import com.atlassian.stash.internal.integrity.IntegrityEventKey;
import com.atlassian.stash.internal.integrity.InternalIntegrityEvent;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.query.NativeQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="applicationIntegrityDao")
public class HibernateApplicationIntegrityDao
extends AbstractHibernateDao<IntegrityEventKey, InternalIntegrityEvent>
implements ApplicationIntegrityDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.asc((String)"event_key"));

    @Autowired
    public HibernateApplicationIntegrityDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }

    @Nonnull
    public List<InternalIntegrityEvent> getLatestEvents(int limit) {
        return this.session().createQuery("from InternalIntegrityEvent order by timestamp desc").setMaxResults(limit).list();
    }

    public void createWithTimestamp(@Nonnull IntegrityEventKey key, @Nonnull String node) {
        String keyValue = key.getId();
        this.executeUpdate(this.session().createNativeQuery("insert into bb_integrity_event (event_key, event_timestamp, event_node) values (:key, current_timestamp, :node)"), keyValue, node);
    }

    public void setTimestamp(@Nonnull IntegrityEventKey key, @Nonnull String node) {
        String keyValue = key.getId();
        int updates = this.executeUpdate(this.session().createNativeQuery("update bb_integrity_event set event_timestamp = current_timestamp, event_node = :node where event_key = :key"), keyValue, node);
        if (updates == 0) {
            this.createWithTimestamp(key, node);
        }
    }

    public boolean updateTimestampIfSameNode(@Nonnull IntegrityEventKey key, @Nonnull String oldNode, @Nonnull String newNode) {
        String keyValue = key.getId();
        int updates = this.session().createNativeQuery("update bb_integrity_event set event_timestamp = current_timestamp, event_node = :newNode where event_key = :key and event_node = :oldNode").addSynchronizedEntityClass(InternalIntegrityEvent.class).setParameter("key", (Object)keyValue).setParameter("newNode", (Object)newNode).setParameter("oldNode", (Object)oldNode).executeUpdate();
        return updates == 1;
    }

    private int executeUpdate(@Nonnull NativeQuery sql, @Nonnull String key, @Nonnull String node) {
        return sql.addSynchronizedEntityClass(InternalIntegrityEvent.class).setParameter("key", (Object)key).setParameter("node", (Object)node).executeUpdate();
    }
}

