/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jdbc;

import com.atlassian.bitbucket.Product;
import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.jdbc.UnsupportedJdbcUrlException;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceConverter {
    public static final String H2_DRIVER = "org.h2.Driver";
    public static final String HSQL_DRIVER = "org.hsqldb.jdbcDriver";
    public static final String HSQL_PASSWORD = "";
    public static final String HSQL_URL = "jdbc:hsqldb:%1$s/data/db;shutdown=true;hsqldb.tx=mvlocks";
    public static final String HSQL_USER = "SA";
    public static final String JTDS_DRIVER = "net.sourceforge.jtds.jdbc.Driver";
    public static final String JTDS_PROTOCOL = "jdbc:jtds:sqlserver";
    public static final Pattern JTDS_URL = Pattern.compile("jdbc:jtds:sqlserver://([^:;/]++)(?::([\\d]{1,5}))?(?:/([^;]++))?(?:$|([^:/].*))");
    public static final String LEGACY_ORACLE_DRIVER = "oracle.jdbc.driver.OracleDriver";
    private static final Logger log = LoggerFactory.getLogger(DataSourceConverter.class);

    private DataSourceConverter() {
        throw new IllegalStateException("DataSourceConverter is a utility class");
    }

    public static String rewriteJtdsUrl(String url) {
        Matcher matcher = JTDS_URL.matcher(url);
        if (matcher.matches()) {
            Map<String, String> parameters = DataSourceConverter.parseJtdsParameters(matcher.group(4));
            String databaseName = matcher.group(3);
            if (databaseName == null) {
                databaseName = parameters.remove("databaseName");
            }
            if (databaseName != null && parameters.isEmpty()) {
                int port = DataSourceConverter.parseJtdsPort(matcher.group(2));
                return DbType.MSSQL.generateUrl(matcher.group(1), databaseName, port);
            }
        }
        log.error("JDBC URL {} was not generated by {} and cannot be updated automatically", (Object)url, (Object)Product.NAME);
        throw new UnsupportedJdbcUrlException("The configured JDBC URL is no longer supported");
    }

    public static String rewriteMsSqlUrl(String url) {
        if (!url.contains("encrypt")) {
            return url + "encrypt=false;";
        }
        return url;
    }

    public static String rewritePostgresUrl(String url) {
        if (url.contains("?")) {
            return url;
        }
        return url + "?targetServerType=master";
    }

    private static Map<String, String> parseJtdsParameters(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Maps.newHashMap();
        }
        String[] pieces = value.split(";");
        HashMap<String, String> parameters = new HashMap<String, String>(pieces.length);
        for (String piece : pieces) {
            if (StringUtils.isBlank((CharSequence)piece)) continue;
            String[] keyValue = piece.split("=");
            parameters.put(keyValue[0], keyValue[1]);
        }
        return parameters;
    }

    private static int parseJtdsPort(String value) {
        int port = value == null ? DbType.MSSQL.getDefaultPort() : Integer.parseInt(value);
        return port;
    }
}

