/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jdbc;

import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.home.HomeDirectoryDetails;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.atlassian.stash.internal.jdbc.DataSourceConfigurationFactory;
import com.atlassian.stash.internal.jdbc.DataSourceConverter;
import com.atlassian.stash.internal.jdbc.H2DatabaseValidator;
import com.atlassian.stash.internal.jdbc.SimpleDataSourceConfiguration;
import jakarta.annotation.Nonnull;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataSourceConfigurationFactory
implements DataSourceConfigurationFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataSourceConfigurationFactory.class);
    private final HomeDirectoryDetails homeDirectory;
    private final H2DatabaseValidator h2DatabaseValidator;
    private final boolean ignoreUnsupported;

    public DefaultDataSourceConfigurationFactory(HomeDirectoryDetails homeDirectory, H2DatabaseValidator h2DatabaseValidator, boolean ignoreUnsupported) {
        this.homeDirectory = homeDirectory;
        this.h2DatabaseValidator = h2DatabaseValidator;
        this.ignoreUnsupported = ignoreUnsupported;
    }

    @Nonnull
    public DataSourceConfiguration create(@Nonnull String driverClassName, @Nonnull String url, @Nonnull String user, @Nonnull String password) {
        if ("org.h2.Driver".equals(driverClassName)) {
            Path dataDir = this.homeDirectory.getSharedHome().resolve("data");
            if (!this.ignoreUnsupported) {
                this.h2DatabaseValidator.validate(dataDir);
            }
            if (!Files.isRegularFile(dataDir.resolve("db.mv.db"), new LinkOption[0]) && Files.isRegularFile(dataDir.resolve("db.script"), new LinkOption[0])) {
                driverClassName = "org.hsqldb.jdbcDriver";
                password = "";
                url = String.format("jdbc:hsqldb:%1$s/data/db;shutdown=true;hsqldb.tx=mvlocks", this.homeDirectory.getSharedHomeDir());
                user = "SA";
                log.warn("Detected legacy HSQL database; using HSQL instead of H2");
            }
        } else if ("net.sourceforge.jtds.jdbc.Driver".equals(driverClassName)) {
            log.debug("Replacing jTDS JDBC details with Microsoft equivalents: Driver = [{}], URL = [{}]", (Object)driverClassName, (Object)url);
            driverClassName = DbType.MSSQL.getDriverClassName();
            url = DataSourceConverter.rewriteJtdsUrl(url);
            log.warn("Replaced jTDS JDBC details with Microsoft equivalents: Driver = [{}], URL = [{}]", (Object)driverClassName, (Object)url);
        } else if ("oracle.jdbc.driver.OracleDriver".equals(driverClassName)) {
            driverClassName = DbType.ORACLE.getDriverClassName();
            log.info("Replaced legacy Oracle JDBC driver: {} -> {}", (Object)"oracle.jdbc.driver.OracleDriver", (Object)driverClassName);
        } else if (DbType.POSTGRES.getDriverClassName().equals(driverClassName)) {
            url = DataSourceConverter.rewritePostgresUrl(url);
        } else if (DbType.MSSQL.getDriverClassName().equals(driverClassName)) {
            url = DataSourceConverter.rewriteMsSqlUrl(url);
        }
        return new SimpleDataSourceConfiguration(driverClassName, url, user, password);
    }
}

