/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jdbc;

import com.atlassian.stash.internal.jdbc.SwappableDataSource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PreDestroy;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.springframework.core.InfrastructureProxy;
import org.springframework.jdbc.datasource.DelegatingDataSource;

public class DelegatingSwappableDataSource
implements Closeable,
SwappableDataSource {
    private volatile DataSource delegate;

    public DelegatingSwappableDataSource(DataSource delegate) {
        this.delegate = delegate;
    }

    @Override
    @PreDestroy
    public void close() {
        DataSource dataSource = this.delegate;
        while (dataSource instanceof DelegatingDataSource) {
            dataSource = ((DelegatingDataSource)dataSource).getTargetDataSource();
        }
        if (dataSource instanceof Closeable) {
            try {
                ((Closeable)((Object)dataSource)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Connection getConnection() throws SQLException {
        return this.delegate.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.delegate.getConnection(username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    public Logger getParentLogger() {
        return Logger.getLogger("global");
    }

    public DataSource getWrappedObject() {
        DataSource delegate = this.delegate;
        return delegate instanceof InfrastructureProxy ? (DataSource)((InfrastructureProxy)delegate).getWrappedObject() : delegate;
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    @Nonnull
    public DataSource swap(@Nonnull DataSource target) {
        DataSource old = this.delegate;
        this.delegate = target;
        return old;
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }
}

