/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jdbc;

import com.atlassian.stash.internal.jdbc.UnsupportedH2StoreException;
import jakarta.annotation.Nonnull;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.h2.mvstore.MVStoreTool;

public class H2DatabaseValidator {
    private static final String FILE_LOCKED_MESSAGE = "The file is locked";

    public void validate(@Nonnull Path dataDir) {
        Path dbFile;
        Objects.requireNonNull(dataDir, "dataDir");
        Path pageStoreDbFile = dataDir.resolve("db.h2.db");
        Path mvStoreDbFile = dataDir.resolve("db.mv.db");
        Path path = dbFile = Files.exists(pageStoreDbFile, new LinkOption[0]) ? pageStoreDbFile : mvStoreDbFile;
        if (Files.exists(dbFile, new LinkOption[0]) && !H2DatabaseValidator.isSupportedFormat(dbFile)) {
            throw new UnsupportedH2StoreException("H2 DB file format is no longer supported");
        }
    }

    private static boolean isSupportedFormat(Path filePath) {
        String fileInfo = MVStoreTool.info((String)filePath.toString(), (Writer)new StringWriter());
        return fileInfo == null || fileInfo.startsWith(FILE_LOCKED_MESSAGE);
    }
}

