/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jdbc;

import com.atlassian.bitbucket.util.ProxyUtils;
import com.atlassian.stash.internal.jdbc.ConnectionTracker;
import com.atlassian.stash.internal.util.StackException;
import jakarta.annotation.Nonnull;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyingConnectionTracker
implements ConnectionTracker {
    private final ConcurrentMap<Connection, ConnectionThread> leasesByConnection;
    private final long rejectionCooldown;
    private final int rejectionThreshold;
    private volatile long lastRejection;

    public ProxyingConnectionTracker(int maxConnections, long rejectionCooldown) {
        this.rejectionCooldown = TimeUnit.MINUTES.toNanos(rejectionCooldown);
        this.leasesByConnection = new ConcurrentHashMap<Connection, ConnectionThread>(maxConnections + maxConnections / 2, 0.75f, 3);
        this.rejectionThreshold = (int)Math.ceil((double)maxConnections * 0.9);
    }

    @Override
    public void forEach(@Nonnull BiConsumer<Connection, Thread> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        this.leasesByConnection.values().forEach((? super T v) -> consumer.accept(v.connection, v.thread));
    }

    @Override
    public int getConnectionCount() {
        return this.leasesByConnection.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnectionRejected() {
        long check = System.nanoTime();
        if (check - this.lastRejection > this.rejectionCooldown && this.leasesByConnection.size() >= this.rejectionThreshold) {
            ConcurrentMap<Connection, ConnectionThread> concurrentMap = this.leasesByConnection;
            synchronized (concurrentMap) {
                if (check - this.lastRejection > this.rejectionCooldown) {
                    this.lastRejection = System.nanoTime();
                    Logger log = LoggerFactory.getLogger(ConnectionTracker.class);
                    log.warn("The database pool is exhausted. Stacks for the threads holding connections follow:");
                    this.leasesByConnection.values().forEach((? super T c) -> c.logThreadStackTrace(log));
                }
            }
        }
    }

    @Override
    @Nonnull
    public Connection register(@Nonnull Connection connection) {
        Objects.requireNonNull(connection, "connection");
        Connection proxy = (Connection)ProxyUtils.createProxy(Connection.class, (InvocationHandler)new ConnectionInvocationHandler(connection), (Class[])new Class[0]);
        this.leasesByConnection.put(connection, new ConnectionThread(proxy));
        return proxy;
    }

    private class ConnectionInvocationHandler
    implements InvocationHandler {
        private final Connection delegate;

        private ConnectionInvocationHandler(Connection delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object object = method.invoke((Object)this.delegate, args);
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if ("close".equals(method.getName())) {
                    ProxyingConnectionTracker.this.leasesByConnection.remove(this.delegate);
                }
            }
        }
    }

    private static class ConnectionThread {
        private final Connection connection;
        private final Thread thread;

        private ConnectionThread(Connection connection) {
            this.connection = connection;
            this.thread = Thread.currentThread();
        }

        private void logThreadStackTrace(Logger log) {
            log.warn("Stack trace for {}", (Object)this.thread.getName(), (Object)new StackException(this.thread));
        }
    }
}

