/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jdbc;

import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.atlassian.stash.internal.jdbc.MutableDataSourceConfiguration;
import com.atlassian.stash.internal.jdbc.SimpleDataSourceConfiguration;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;

public class SystemDataSourceConfiguration
implements MutableDataSourceConfiguration {
    private final long connectTimeout;
    private String driverClassName;
    private String password;
    private String url;
    private String user;

    public SystemDataSourceConfiguration(DataSourceConfiguration configuration, long connectTimeout) {
        this.connectTimeout = connectTimeout;
        this.driverClassName = configuration.getDriverClassName();
        this.password = configuration.getPassword();
        this.url = configuration.getUrl();
        this.user = configuration.getUser();
    }

    @Nonnull
    public DataSourceConfiguration copy() {
        return new SimpleDataSourceConfiguration(this.driverClassName, this.url, this.user, this.password);
    }

    @Nonnull
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Nonnull
    public String getPassword() {
        return this.password;
    }

    @Nonnull
    public Properties getProperties() {
        Properties properties = new Properties();
        if (this.connectTimeout > 0L) {
            DbType.forDriver((String)this.getDriverClassName()).ifPresent(dbType -> {
                Duration timeout = Duration.ofSeconds(this.connectTimeout);
                properties.putAll((Map<?, ?>)dbType.getPropertyMap(timeout));
            });
        }
        return properties;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    @Nonnull
    public String getUser() {
        return this.user;
    }

    @Nonnull
    public DataSourceConfiguration update(DataSourceConfiguration configuration) {
        DataSourceConfiguration old = this.copy();
        this.driverClassName = configuration.getDriverClassName();
        this.password = configuration.getPassword();
        this.url = configuration.getUrl();
        this.user = configuration.getUser();
        return old;
    }

    public String toString() {
        return this.user + "@" + this.url + " via " + this.driverClassName;
    }
}

