/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.job;

import com.atlassian.bitbucket.job.JobSearchRequest;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.job.InternalJob;
import com.atlassian.stash.internal.job.JobDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import jakarta.annotation.Nonnull;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hibernate.SessionFactory;
import org.springframework.stereotype.Repository;

@Repository(value="jobDao")
public class HibernateJobDao
extends AbstractHibernateDao<Long, InternalJob>
implements JobDao {
    public static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.asc((String)"updatedDate"));

    public HibernateJobDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public InternalJob create(InternalJob entity) {
        return (InternalJob)HibernateUtils.initialize((Object)((InternalJob)super.create((Object)entity)));
    }

    @Nonnull
    public Page<InternalJob> findAll(PageRequest pageRequest) {
        return HibernateUtils.initializePage((Page)super.findAll(pageRequest));
    }

    @Nonnull
    public Page<InternalJob> findAll(PageRequest pageRequest, java.util.function.Predicate<? super InternalJob> predicate) {
        return HibernateUtils.initializePage((Page)super.findAll(pageRequest, predicate));
    }

    public InternalJob getById(Long id) {
        return (InternalJob)HibernateUtils.initialize((Object)((InternalJob)super.getById((Serializable)id)));
    }

    @Nonnull
    public List<InternalJob> getByIds(@Nonnull Collection<Long> ids) {
        return HibernateUtils.initializeList((List)super.getByIds(ids));
    }

    public InternalJob loadById(Long id) {
        return (InternalJob)HibernateUtils.initialize((Object)((InternalJob)super.loadById((Serializable)id)));
    }

    public void refresh(InternalJob entity) {
        super.refresh((Object)entity);
        HibernateUtils.initialize((Object)entity);
    }

    @Nonnull
    public Page<InternalJob> search(@Nonnull JobSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(InternalJob.class);
        Root root = criteria.from(InternalJob.class);
        criteria.select((Selection)root).where(HibernateJobDao.buildPredicatesFromRequest((Root<InternalJob>)root, builder, request)).orderBy(new Order[]{builder.asc((Expression)root.get("updatedDate"))});
        return HibernateUtils.initializePage((Page)this.pageQuery(this.session().createQuery(criteria), pageRequest));
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }

    private static Predicate[] buildPredicatesFromRequest(Root<InternalJob> root, CriteriaBuilder builder, JobSearchRequest request) {
        ArrayList<CriteriaBuilder.In> predicates = new ArrayList<CriteriaBuilder.In>();
        request.getType().ifPresent(reqType -> predicates.add((CriteriaBuilder.In)builder.equal((Expression)root.get("type"), reqType)));
        if (!request.getStates().isEmpty()) {
            CriteriaBuilder.In inClause = builder.in((Expression)root.get("state"));
            request.getStates().forEach(arg_0 -> ((CriteriaBuilder.In)inClause).value(arg_0));
            predicates.add(inClause);
        }
        return predicates.toArray(new Predicate[0]);
    }
}

