/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.job;

import com.atlassian.bitbucket.job.JobMessageSearchRequest;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.job.InternalJobMessage;
import com.atlassian.stash.internal.job.InternalJobMessage_;
import com.atlassian.stash.internal.job.InternalJob_;
import com.atlassian.stash.internal.job.JobMessageDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import jakarta.annotation.Nonnull;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hibernate.SessionFactory;
import org.springframework.stereotype.Repository;

@Repository(value="jobMessageDao")
public class HibernateJobMessageDao
extends AbstractHibernateDao<Long, InternalJobMessage>
implements JobMessageDao {
    public static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.asc((String)"createdDate"));

    public HibernateJobMessageDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public long count(@Nonnull JobMessageSearchRequest request) {
        Objects.requireNonNull(request, "request");
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root root = criteria.from(InternalJobMessage.class);
        criteria.select((Selection)builder.count((Expression)root)).where(this.buildPredicatesFromRequest((Root<InternalJobMessage>)root, builder, request));
        return (Long)this.session().createQuery(criteria).uniqueResult();
    }

    @Nonnull
    public InternalJobMessage create(InternalJobMessage entity) {
        return (InternalJobMessage)HibernateUtils.initialize((Object)((InternalJobMessage)super.create((Object)entity)));
    }

    @Nonnull
    public Page<InternalJobMessage> findAll(PageRequest pageRequest) {
        return HibernateUtils.initializePage((Page)super.findAll(pageRequest));
    }

    @Nonnull
    public Page<InternalJobMessage> findAll(PageRequest pageRequest, java.util.function.Predicate<? super InternalJobMessage> predicate) {
        return HibernateUtils.initializePage((Page)super.findAll(pageRequest, predicate));
    }

    public InternalJobMessage getById(Long id) {
        return (InternalJobMessage)HibernateUtils.initialize((Object)((InternalJobMessage)super.getById((Serializable)id)));
    }

    @Nonnull
    public List<InternalJobMessage> getByIds(@Nonnull Collection<Long> ids) {
        return HibernateUtils.initializeList((List)super.getByIds(ids));
    }

    public InternalJobMessage loadById(Long id) {
        return (InternalJobMessage)HibernateUtils.initialize((Object)((InternalJobMessage)super.loadById((Serializable)id)));
    }

    public void refresh(InternalJobMessage entity) {
        super.refresh((Object)entity);
        HibernateUtils.initialize((Object)entity);
    }

    @Nonnull
    public Page<InternalJobMessage> search(@Nonnull JobMessageSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(InternalJobMessage.class);
        Root root = criteria.from(InternalJobMessage.class);
        criteria.select((Selection)root).where(this.buildPredicatesFromRequest((Root<InternalJobMessage>)root, builder, request)).orderBy(new Order[]{builder.asc((Expression)root.get(InternalJobMessage_.createdDate))});
        return HibernateUtils.initializePage((Page)this.pageQuery(this.session().createQuery(criteria), pageRequest));
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }

    private Predicate[] buildPredicatesFromRequest(Root<InternalJobMessage> root, CriteriaBuilder builder, JobMessageSearchRequest request) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        request.getJob().ifPresent(j -> predicates.add(builder.equal((Expression)root.get(InternalJobMessage_.job).get(InternalJob_.id), (Object)j.getId())));
        if (!request.getSeverities().isEmpty()) {
            predicates.add(root.get(InternalJobMessage_.severity).in((Collection)request.getSeverities()));
        }
        request.getSubject().ifPresent(sub -> predicates.add(builder.equal((Expression)root.get(InternalJobMessage_.subject), sub)));
        return predicates.toArray(new Predicate[0]);
    }
}

