/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.license;

import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.jdbc.DataSourceConverter;
import com.atlassian.stash.internal.jdbc.H2DatabaseValidator;
import com.atlassian.stash.internal.license.LicenseRetrievalDao;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nullable;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataAccessResourceFailureException;

public class JdbcLicenseRetrievalDao
implements LicenseRetrievalDao,
EnvironmentAware {
    private final H2DatabaseValidator h2DatabaseValidator;
    private final Path sharedHome;
    private Environment environment;

    public JdbcLicenseRetrievalDao(Path sharedHome, H2DatabaseValidator h2DatabaseValidator) {
        this.sharedHome = sharedHome;
        this.h2DatabaseValidator = h2DatabaseValidator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String getLicense() throws DataAccessResourceFailureException {
        try (Connection connection = this.getDatabaseConnection();){
            if (this.isAppPropertyTablePresent(connection)) {
                String string2 = this.getLicenseFromDatabase(connection);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (SQLException e) {
            throw new DataAccessResourceFailureException("Unable to retrieve license details from the database: ", (Throwable)e);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @VisibleForTesting
    Connection getDatabaseConnection() throws SQLException {
        String url;
        String driver = this.environment.getRequiredProperty("jdbc.driver");
        String driverUrl = url = this.environment.getRequiredProperty("jdbc.url");
        if ("org.h2.Driver".equals(driver) && !Boolean.parseBoolean(this.environment.getProperty("jdbc.ignoreunsupported"))) {
            Path dataDir = this.sharedHome.resolve("data");
            this.h2DatabaseValidator.validate(dataDir);
        } else if ("net.sourceforge.jtds.jdbc.Driver".equals(driver)) {
            driverUrl = DataSourceConverter.rewriteJtdsUrl(url);
        } else if (DbType.POSTGRES.getDriverClassName().equals(driver)) {
            driverUrl = DataSourceConverter.rewritePostgresUrl(url);
        } else if (DbType.MSSQL.getDriverClassName().equals(driver)) {
            driverUrl = DataSourceConverter.rewriteMsSqlUrl(url);
        }
        return DriverManager.getConnection(driverUrl, this.environment.getProperty("jdbc.user"), this.environment.getProperty("jdbc.password"));
    }

    private String getLicenseFromDatabase(Connection connection) throws SQLException {
        try (ResultSet licenseRs = connection.createStatement().executeQuery("select prop_value from app_property where prop_key='license'");){
            if (licenseRs.next()) {
                String string = licenseRs.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    private boolean isAppPropertyTablePresent(Connection connection) throws SQLException {
        try (ResultSet rs = connection.getMetaData().getTables(connection.getCatalog(), null, "%", new String[]{"TABLE"});){
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"APP_PROPERTY")) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

