/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.atlassian.stash.internal.user.InternalServiceUser;
import com.google.common.collect.Iterables;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;

public class AddServiceUserColumnsChange
extends AbstractCustomChange
implements CustomTaskChange {
    private static final int BATCH_SIZE = 100;
    private static final Logger log = LoggerFactory.getLogger(AddServiceUserColumnsChange.class);
    private int updatedCount;

    public void execute(Database database) throws CustomChangeException {
        JdbcTemplate template = LiquibaseUtils.getJdbcTemplate((Database)database);
        try {
            List<UserDetails> existingUsers = this.getServiceUsers(template);
            for (List batch : Iterables.partition(existingUsers, (int)100)) {
                this.updateBatch(template, batch);
            }
            this.updatedCount = existingUsers.size();
            log.debug("Updated {} service users", (Object)this.updatedCount);
        }
        catch (DataAccessException e) {
            throw new CustomChangeException("Failed to initialise added columns on sta_service_user", (Throwable)e);
        }
    }

    private boolean isFree(JdbcTemplate template, String name, String slug) {
        return (Integer)template.queryForObject("select count(user_id) from sta_service_user where name = ? or slug = ?", Integer.class, new Object[]{name, slug}) == 0;
    }

    public String getConfirmationMessage() {
        return this.updatedCount + " sta_service_user rows were updated";
    }

    private List<UserDetails> getServiceUsers(JdbcTemplate template) {
        ArrayList<UserDetails> batch = new ArrayList<UserDetails>();
        template.query("select user_id, display_name from sta_service_user order by user_id", rs -> batch.add(new UserDetails(rs.getInt(1), rs.getString(2))));
        return batch;
    }

    private void updateBatch(final JdbcTemplate template, final List<UserDetails> batch) {
        if (batch.isEmpty()) {
            return;
        }
        String sql = "UPDATE sta_service_user SET name = ?, slug = ?, active = ?, label = ? where user_id = ?";
        template.batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                String slug;
                String name;
                UserDetails details = (UserDetails)batch.get(i);
                while (!AddServiceUserColumnsChange.this.isFree(template, name = StringUtils.substring((String)DefaultSecureTokenGenerator.getInstance().generateToken(), (int)0, (int)16), slug = InternalServiceUser.slugify((String)name))) {
                }
                ps.setString(1, name);
                ps.setString(2, slug);
                ps.setBoolean(3, true);
                ps.setString(4, details.getLabel());
                ps.setInt(5, details.id);
            }

            public int getBatchSize() {
                return batch.size();
            }
        });
    }

    private static class UserDetails {
        private final String displayName;
        private final int id;

        UserDetails(int id, String displayName) {
            this.displayName = displayName;
            this.id = id;
        }

        public String getLabel() {
            return this.displayName != null && this.displayName.contains("(") && this.displayName.contains(")") ? "access-key" : "bot";
        }
    }
}

