/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import java.sql.Blob;
import java.util.HashMap;
import java.util.Map;
import liquibase.change.custom.CustomTaskChange;
import liquibase.change.custom.CustomTaskRollback;
import liquibase.database.Database;
import org.apache.commons.codec.binary.Base64;
import org.springframework.dao.DataRetrievalFailureException;

public class BlobBase64EncodeChange
extends AbstractCustomChange
implements CustomTaskChange,
CustomTaskRollback {
    private String tableName;
    private String primaryKey;
    private String fromColumnName;
    private String toColumnName;
    private int charLimit = -1;

    public void execute(Database database) {
        Map<Integer, String> data = this.selectData(database);
        this.updateTable(database, data);
    }

    private Map<Integer, String> selectData(Database database) {
        String sql = "SELECT " + this.primaryKey + ", " + this.fromColumnName + " FROM " + this.tableName;
        HashMap<Integer, String> data = new HashMap<Integer, String>();
        LiquibaseUtils.getJdbcTemplate((Database)database).query(sql, rs -> {
            String transformedValue;
            long blobLength;
            int key = rs.getInt(this.primaryKey);
            Blob blob = rs.getBlob(this.fromColumnName);
            byte[] value = blob.getBytes(1L, (int)(blobLength = blob.length()));
            String string = transformedValue = value != null ? new String(Base64.encodeBase64((byte[])value)) : null;
            if (this.charLimit > 0 && transformedValue != null && transformedValue.length() > this.charLimit) {
                throw new DataRetrievalFailureException(String.format("Failed to transform unbound BLOB on column %s to base64 bound char limit of %d on %s in table %s, key: %d", this.fromColumnName, this.charLimit, this.toColumnName, this.tableName, key));
            }
            data.put(key, transformedValue);
        });
        return data;
    }

    private void updateTable(Database database, Map<Integer, String> data) {
        if (data.isEmpty()) {
            return;
        }
        String sql = "UPDATE " + this.tableName + " SET " + this.toColumnName + " = ? WHERE " + this.primaryKey + " = ?";
        LiquibaseUtils.getJdbcTemplate((Database)database).batchUpdate(sql, data.entrySet(), data.size(), (statement, entry) -> {
            statement.setString(1, (String)entry.getValue());
            statement.setInt(2, (Integer)entry.getKey());
        });
    }

    public void rollback(Database database) {
        LiquibaseUtils.getJdbcTemplate((Database)database).update("UPDATE " + this.tableName + " SET " + this.toColumnName + " = NULL");
    }

    public String getConfirmationMessage() {
        return String.format("Converted blob data in %1$s.%2$s to base64 data in %1$s.%3$s", this.tableName, this.fromColumnName, this.toColumnName);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setFromColumnName(String fromColumnName) {
        this.fromColumnName = fromColumnName;
    }

    public void setToColumnName(String toColumnName) {
        this.toColumnName = toColumnName;
    }

    public void setCharLimit(Integer charLimit) {
        this.charLimit = charLimit;
    }
}

