/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import java.util.HashMap;
import java.util.Map;
import liquibase.change.custom.CustomTaskChange;
import liquibase.change.custom.CustomTaskRollback;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class FillInRootCommentsChange
extends AbstractCustomChange
implements CustomTaskChange,
CustomTaskRollback {
    private static final int MAX_REPLY_NESTING = 50;
    private static final Logger log = LoggerFactory.getLogger(FillInRootCommentsChange.class);

    public void execute(Database database) throws CustomChangeException {
        int level;
        Map<Long, Long> rootRepliesAndTheirRoots = this.getRootRepliesAndTheirRoots(database);
        log.debug("Setting roots on {} top-level replies", (Object)rootRepliesAndTheirRoots.size());
        this.setRoots(database, rootRepliesAndTheirRoots);
        Map<Long, Long> unrootedReplies = this.getUnrootedReplies(database);
        for (level = 0; level < 50 && !unrootedReplies.isEmpty(); ++level) {
            log.debug("Setting roots on {} replies at level {}", (Object)unrootedReplies.size(), (Object)(level + 1));
            this.setRoots(database, unrootedReplies);
            unrootedReplies = this.getUnrootedReplies(database);
        }
        if (!unrootedReplies.isEmpty()) {
            throw new CustomChangeException(String.format("Failed to set comment roots - too much comment nesting detected. Gave up at level %d", level + 1));
        }
    }

    public String getConfirmationMessage() {
        return "Comment roots successfully set for all replies";
    }

    public void rollback(Database database) throws CustomChangeException {
        try {
            JdbcTemplate template = LiquibaseUtils.getJdbcTemplate((Database)database);
            template.update("UPDATE sta_comment SET root_id = NULL");
        }
        catch (DataAccessException e) {
            log.error("Failed to rollback rooting of replies", (Throwable)e);
            throw new CustomChangeException("Failed to rollback data in sta_comment", (Throwable)e);
        }
    }

    private Map<Long, Long> getRootRepliesAndTheirRoots(Database database) throws CustomChangeException {
        try {
            HashMap<Long, Long> result = new HashMap<Long, Long>();
            JdbcTemplate template = LiquibaseUtils.getJdbcTemplate((Database)database);
            template.query("select c1.id as reply_id, c2.id as root_id from sta_comment c1 inner join sta_comment c2 on c1.parent_id = c2.id where c2.parent_id is NULL", rs -> {
                long replyId = rs.getLong("reply_id");
                long rootId = rs.getLong("root_id");
                result.put(replyId, rootId);
            });
            return result;
        }
        catch (DataAccessException e) {
            log.error("Failed to query root replies", (Throwable)e);
            throw new CustomChangeException("Failed to select data from sta_comment", (Throwable)e);
        }
    }

    private Map<Long, Long> getUnrootedReplies(Database database) throws CustomChangeException {
        try {
            HashMap<Long, Long> result = new HashMap<Long, Long>();
            JdbcTemplate template = LiquibaseUtils.getJdbcTemplate((Database)database);
            template.query("select c1.id as reply_id, c2.root_id as root_id from sta_comment c1 inner join sta_comment c2 on c1.parent_id = c2.id where c1.root_id is NULL and c2.root_id is not NULL", rs -> {
                long replyId = rs.getLong("reply_id");
                long rootId = rs.getLong("root_id");
                result.put(replyId, rootId);
            });
            return result;
        }
        catch (DataAccessException e) {
            log.error("Failed to query unrooted replies", (Throwable)e);
            throw new CustomChangeException("Failed to select data from sta_comment", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private void setRoots(Database database, Map<Long, Long> repliesAndTheirRoots) throws CustomChangeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

