/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import liquibase.change.custom.CustomTaskChange;
import liquibase.change.custom.CustomTaskRollback;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;

public class PopulatePersonalProjectsChange
extends AbstractCustomChange
implements CustomTaskChange,
CustomTaskRollback {
    private int count;

    public void execute(Database database) throws CustomChangeException {
        JdbcTemplate template = LiquibaseUtils.getJdbcTemplate((Database)database);
        try {
            this.execute(template);
        }
        catch (DataAccessException e) {
            throw new CustomChangeException("Personal projects could not be populated", (Throwable)e);
        }
    }

    public String getConfirmationMessage() {
        return "Populated " + this.count + " personal project" + (this.count == 1 ? "" : "s");
    }

    public void rollback(Database database) throws CustomChangeException {
        JdbcTemplate template = LiquibaseUtils.getJdbcTemplate((Database)database);
        try {
            template.update("delete * from sta_personal_project");
        }
        catch (DataAccessException e) {
            throw new CustomChangeException("Populated personal projects could not be rolled back", (Throwable)e);
        }
    }

    private void execute(JdbcTemplate template) {
        LinkedHashMap usernamesByProjectId = Maps.newLinkedHashMap();
        template.query("select id, project_key from project where project_type = 1", rs -> {
            usernamesByProjectId.put(rs.getInt(1), InternalPersonalProject.getPersonalProjectOwner((String)rs.getString(2)));
            if (usernamesByProjectId.size() == 25) {
                this.process(template, usernamesByProjectId);
            }
        });
        if (!usernamesByProjectId.isEmpty()) {
            this.process(template, usernamesByProjectId);
        }
    }

    private Map<String, Integer> findUsers(JdbcTemplate template, Collection<String> usernames) {
        String questions = StringUtils.repeat((String)"?", (String)", ", (int)usernames.size());
        HashMap<String, Integer> userIdsByUsername = new HashMap<String, Integer>(usernames.size(), 1.0f);
        template.query("select id, name from stash_user where name in (" + questions + ")", usernames.toArray(), rs -> userIdsByUsername.put(rs.getString(2), rs.getInt(1)));
        return userIdsByUsername;
    }

    private void process(JdbcTemplate template, Map<Integer, String> usernamesByProjectId) {
        Map<String, Integer> userIdsByUsername = this.findUsers(template, usernamesByProjectId.values());
        final ArrayList rows = Lists.newArrayListWithCapacity((int)usernamesByProjectId.size());
        for (Map.Entry<Integer, String> entry : usernamesByProjectId.entrySet()) {
            Integer owner = userIdsByUsername.get(entry.getValue());
            if (owner == null) {
                throw new DataIntegrityViolationException("The owner for [" + entry.getValue() + "] could not be found");
            }
            rows.add(new ProjectAndOwner(entry.getKey(), owner));
        }
        usernamesByProjectId.clear();
        userIdsByUsername.clear();
        this.count += template.batchUpdate("insert into sta_personal_project (project_id, owner_id) values (?, ?)", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return rows.size();
            }

            public void setValues(PreparedStatement statement, int index) throws SQLException {
                ProjectAndOwner row = (ProjectAndOwner)rows.get(index);
                statement.setInt(1, row.projectId);
                statement.setInt(2, row.ownerId);
            }
        }).length;
    }

    private static class ProjectAndOwner {
        private final int ownerId;
        private final int projectId;

        ProjectAndOwner(int projectId, int ownerId) {
            this.projectId = projectId;
            this.ownerId = ownerId;
        }
    }
}

